/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.schema.source;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.schema.table.TsTable;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnSchema;
import org.apache.iotdb.commons.utils.PathUtils;
import org.apache.iotdb.db.queryengine.execution.operator.process.FilterAndProjectOperator;
import org.apache.iotdb.db.queryengine.execution.operator.schema.source.TableDeviceQuerySource;
import org.apache.iotdb.db.queryengine.transformation.dag.column.ColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.leaf.LeafColumnTransformer;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.info.IDeviceSchemaInfo;
import org.apache.iotdb.db.schemaengine.table.DataNodeTreeViewSchemaUtils;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.common.conf.TSFileDescriptor;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.common.block.TsBlockBuilder;

public abstract class DevicePredicateHandler
implements AutoCloseable {
    private final List<LeafColumnTransformer> filterLeafColumnTransformerList;
    protected final ColumnTransformer filterOutputTransformer;
    private final List<TSDataType> inputDataTypes;
    private final List<TsTableColumnSchema> columnSchemaList;
    private final int idIndex;
    protected static final int DEFAULT_MAX_TS_BLOCK_LINE_NUMBER = TSFileDescriptor.getInstance().getConfig().getMaxTsBlockLineNumber();
    protected final List<IDeviceSchemaInfo> deviceSchemaBatch = new ArrayList<IDeviceSchemaInfo>(DEFAULT_MAX_TS_BLOCK_LINE_NUMBER);
    protected final List<Integer> indexes = new ArrayList<Integer>();
    protected TsBlock curBlock;
    protected Column curFilterColumn;

    protected DevicePredicateHandler(List<LeafColumnTransformer> filterLeafColumnTransformerList, ColumnTransformer filterOutputTransformer, List<TsTableColumnSchema> columnSchemaList, String database, TsTable table) {
        this.filterLeafColumnTransformerList = filterLeafColumnTransformerList;
        this.filterOutputTransformer = filterOutputTransformer;
        this.columnSchemaList = columnSchemaList;
        this.inputDataTypes = columnSchemaList.stream().map(TsTableColumnSchema::getDataType).collect(Collectors.toList());
        this.idIndex = PathUtils.isTableModelDatabase((String)database) ? 3 : DataNodeTreeViewSchemaUtils.getPatternNodes(table).length;
    }

    public void addBatch(IDeviceSchemaInfo deviceSchemaInfo) {
        this.deviceSchemaBatch.add(deviceSchemaInfo);
        if (this.deviceSchemaBatch.size() >= DEFAULT_MAX_TS_BLOCK_LINE_NUMBER) {
            this.prepareBatchResult();
        }
    }

    protected void clear() {
        this.curBlock = null;
        this.curFilterColumn = null;
        this.indexes.clear();
        this.deviceSchemaBatch.clear();
    }

    public void prepareBatchResult() {
        if (this.deviceSchemaBatch.isEmpty()) {
            return;
        }
        TsBlockBuilder builder = new TsBlockBuilder(this.inputDataTypes);
        this.deviceSchemaBatch.forEach(deviceSchemaInfo -> TableDeviceQuerySource.transformToTableDeviceTsBlockColumns(deviceSchemaInfo, builder, this.columnSchemaList, this.idIndex));
        this.curBlock = builder.build();
        if (this.withoutFilter()) {
            return;
        }
        this.filterLeafColumnTransformerList.forEach(leafColumnTransformer -> leafColumnTransformer.initFromTsBlock(this.curBlock));
        this.filterOutputTransformer.tryEvaluate();
        Column filterColumn = this.filterOutputTransformer.getColumn();
        for (int j = 0; j < this.deviceSchemaBatch.size(); ++j) {
            if (!FilterAndProjectOperator.satisfy(filterColumn, j)) continue;
            this.indexes.add(j);
        }
        this.curFilterColumn = filterColumn;
    }

    protected boolean withoutFilter() {
        return Objects.isNull(this.filterOutputTransformer);
    }

    protected boolean hasComputedResult() {
        return Objects.nonNull(this.curBlock);
    }

    @Override
    public void close() throws MetadataException {
        this.clear();
        if (Objects.nonNull(this.filterOutputTransformer)) {
            this.filterOutputTransformer.close();
        }
    }
}

