/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tool.data;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.iotdb.cli.utils.IoTPrinter;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.utils.NodeUrlUtils;
import org.apache.iotdb.exception.ArgsErrorException;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.session.Session;
import org.apache.iotdb.tool.common.Constants;
import org.apache.iotdb.tool.common.ImportTsFileOperation;
import org.apache.iotdb.tool.common.OptionsUtil;
import org.apache.iotdb.tool.data.AbstractDataTool;
import org.apache.iotdb.tool.data.AbstractImportData;
import org.apache.iotdb.tool.data.ImportDataTable;
import org.apache.iotdb.tool.data.ImportDataTree;
import org.apache.tsfile.enums.TSDataType;

public class ImportData
extends AbstractDataTool {
    private static final IoTPrinter ioTPrinter = new IoTPrinter(System.out);
    private static Session session;

    public static void main(String[] args) throws IoTDBConnectionException {
        int ftIndex;
        Options helpOptions = OptionsUtil.createHelpOptions();
        Options tsFileOptions = OptionsUtil.createImportTsFileOptions();
        Options csvOptions = OptionsUtil.createImportCsvOptions();
        Options sqlOptions = OptionsUtil.createImportSqlOptions();
        HelpFormatter hf = new HelpFormatter();
        hf.setOptionComparator(null);
        hf.setWidth(92);
        CommandLine commandLine = null;
        DefaultParser parser = new DefaultParser();
        if (args == null || args.length == 0) {
            ImportData.printHelpOptions("Please obtain help information for the corresponding data type based on different parameters, for example:\n./import_data.sh -help tsfile\n./import_data.sh -help sql\n./import_data.sh -help csv", "Import Data", hf, tsFileOptions, csvOptions, sqlOptions, true);
            System.exit(1);
        }
        try {
            commandLine = parser.parse(helpOptions, args, true);
        }
        catch (ParseException e) {
            ImportData.printHelpOptions("Please obtain help information for the corresponding data type based on different parameters, for example:\n./import_data.sh -help tsfile\n./import_data.sh -help sql\n./import_data.sh -help csv", "Import Data", hf, tsFileOptions, csvOptions, sqlOptions, true);
            System.exit(1);
        }
        List<String> argList = Arrays.asList(args);
        int helpIndex = argList.indexOf("-help");
        int sql_dialect = argList.indexOf("-sql_dialect");
        if (sql_dialect >= 0 && !"tree".equalsIgnoreCase(argList.get(sql_dialect + 1))) {
            String sqlDialectValue = argList.get(sql_dialect + 1);
            if ("table".equalsIgnoreCase(sqlDialectValue)) {
                sqlDialectTree = false;
                tsFileOptions = OptionsUtil.createTableImportTsFileOptions();
                csvOptions = OptionsUtil.createTableImportCsvOptions();
                sqlOptions = OptionsUtil.createTableImportSqlOptions();
            } else {
                ioTPrinter.println(String.format("sql_dialect %s is not support", sqlDialectValue));
                ImportData.printHelpOptions("Please obtain help information for the corresponding data type based on different parameters, for example:\n./import_data.sh -help tsfile\n./import_data.sh -help sql\n./import_data.sh -help csv", "Import Data", hf, tsFileOptions, csvOptions, sqlOptions, true);
                System.exit(1);
            }
        }
        if ((ftIndex = argList.indexOf("-ft")) < 0) {
            ftIndex = argList.indexOf("-file_type");
        }
        if (helpIndex >= 0) {
            fileType = argList.get(helpIndex + 1);
            if (StringUtils.isNotBlank((CharSequence)fileType)) {
                if ("tsfile".equalsIgnoreCase(fileType)) {
                    ImportData.printHelpOptions(null, "Import Data", hf, tsFileOptions, null, null, false);
                } else if ("csv".equalsIgnoreCase(fileType)) {
                    ImportData.printHelpOptions(null, "Import Data", hf, null, csvOptions, null, false);
                } else if ("sql".equalsIgnoreCase(fileType)) {
                    ImportData.printHelpOptions(null, "Import Data", hf, null, null, sqlOptions, false);
                } else {
                    ioTPrinter.println(String.format("File type %s is not support", fileType));
                    ImportData.printHelpOptions("Please obtain help information for the corresponding data type based on different parameters, for example:\n./import_data.sh -help tsfile\n./import_data.sh -help sql\n./import_data.sh -help csv", "Import Data", hf, tsFileOptions, csvOptions, sqlOptions, true);
                }
            } else {
                ImportData.printHelpOptions("Please obtain help information for the corresponding data type based on different parameters, for example:\n./import_data.sh -help tsfile\n./import_data.sh -help sql\n./import_data.sh -help csv", "Import Data", hf, tsFileOptions, csvOptions, sqlOptions, true);
            }
            System.exit(1);
        } else if (ftIndex >= 0) {
            fileType = argList.get(ftIndex + 1);
            if (StringUtils.isNotBlank((CharSequence)fileType)) {
                if ("tsfile".equalsIgnoreCase(fileType)) {
                    try {
                        commandLine = parser.parse(tsFileOptions, args);
                    }
                    catch (ParseException e) {
                        ioTPrinter.println("Parse error: " + e.getMessage());
                        ImportData.printHelpOptions(null, "Import Data", hf, tsFileOptions, null, null, false);
                        System.exit(1);
                    }
                } else if ("csv".equalsIgnoreCase(fileType)) {
                    try {
                        commandLine = parser.parse(csvOptions, args);
                    }
                    catch (ParseException e) {
                        ioTPrinter.println("Parse error: " + e.getMessage());
                        ImportData.printHelpOptions(null, "Import Data", hf, null, csvOptions, null, false);
                        System.exit(1);
                    }
                } else if ("sql".equalsIgnoreCase(fileType)) {
                    try {
                        commandLine = parser.parse(sqlOptions, args);
                    }
                    catch (ParseException e) {
                        ioTPrinter.println("Parse error: " + e.getMessage());
                        ImportData.printHelpOptions(null, "Import Data", hf, null, null, sqlOptions, false);
                        System.exit(1);
                    }
                } else {
                    ioTPrinter.println(String.format("File type %s is not support", fileType));
                    ImportData.printHelpOptions("Please obtain help information for the corresponding data type based on different parameters, for example:\n./import_data.sh -help tsfile\n./import_data.sh -help sql\n./import_data.sh -help csv", "Import Data", hf, tsFileOptions, csvOptions, sqlOptions, true);
                    System.exit(1);
                }
            } else {
                ioTPrinter.println(String.format("Invalid args: Required values for option '%s' not provided", "file_type"));
                System.exit(1);
            }
        } else {
            ioTPrinter.println(String.format("Invalid args: Required values for option '%s' not provided", "file_type"));
            System.exit(1);
        }
        try {
            ImportData.parseBasicParams(commandLine);
            String filename = commandLine.getOptionValue("s");
            if (filename == null) {
                ioTPrinter.println("Please obtain help information for the corresponding data type based on different parameters, for example:\n./import_data.sh -help tsfile\n./import_data.sh -help sql\n./import_data.sh -help csv");
                ImportData.printHelpOptions(null, "Import Data", hf, tsFileOptions, csvOptions, sqlOptions, true);
                System.exit(1);
            }
            ImportData.parseSpecialParams(commandLine);
        }
        catch (ArgsErrorException e) {
            ioTPrinter.println("Args error: " + e.getMessage());
            System.exit(1);
        }
        catch (Exception e) {
            ioTPrinter.println("Encounter an error, because: " + e.getMessage());
            System.exit(1);
        }
        int resultCode = ImportData.importFromTargetPathAsync();
        System.exit(resultCode);
    }

    private static void parseSpecialParams(CommandLine commandLine) throws ArgsErrorException {
        String onFail;
        String[] opTypeInferValues;
        timeZoneID = commandLine.getOptionValue("tz");
        targetPath = commandLine.getOptionValue("s");
        if (commandLine.getOptionValue("batch") != null) {
            batchPointSize = Integer.parseInt(commandLine.getOptionValue("batch"));
        }
        if (commandLine.getOptionValue("fd") != null) {
            failedFileDirectory = commandLine.getOptionValue("fd");
            File file = new File(failedFileDirectory);
            if (!file.isDirectory()) {
                file.mkdir();
                failedFileDirectory = file.getAbsolutePath() + File.separator;
            } else if (!failedFileDirectory.endsWith("/") && !failedFileDirectory.endsWith("\\")) {
                failedFileDirectory = failedFileDirectory + File.separator;
            }
        }
        if (commandLine.getOptionValue("aligned") != null) {
            aligned = Boolean.valueOf(commandLine.getOptionValue("aligned"));
        }
        if (commandLine.getOptionValue("tn") != null && (threadNum = Integer.parseInt(commandLine.getOptionValue("tn"))) <= 0) {
            ioTPrinter.println(String.format("error: Invalid thread number '%s'. Please set a positive integer.", threadNum));
            System.exit(1);
        }
        if (commandLine.getOptionValue("tp") != null) {
            timestampPrecision = commandLine.getOptionValue("tp");
        }
        if ((opTypeInferValues = commandLine.getOptionValues("ti")) != null && opTypeInferValues.length > 0) {
            for (String opTypeInferValue : opTypeInferValues) {
                if (!opTypeInferValue.contains("=")) continue;
                String[] typeInfoExpressionArr = opTypeInferValue.split("=");
                String key = typeInfoExpressionArr[0];
                String value = typeInfoExpressionArr[1];
                ImportData.applyTypeInferArgs(key, value);
            }
        }
        if (commandLine.getOptionValue("lpf") != null) {
            linesPerFailedFile = Integer.parseInt(commandLine.getOptionValue("lpf"));
        }
        if (commandLine.getOptionValue("db") != null) {
            database = commandLine.getOptionValue("db");
        }
        if (commandLine.getOptionValue("table") != null) {
            table = commandLine.getOptionValue("table");
        }
        if (commandLine.getOptionValue("start_time") != null) {
            startTime = commandLine.getOptionValue("start_time");
        }
        if (commandLine.getOptionValue("end_time") != null) {
            endTime = commandLine.getOptionValue("end_time");
        }
        try {
            boolean bl = isRemoteLoad = !NodeUrlUtils.containsLocalAddress(Collections.singletonList(host));
            if (!sqlDialectTree && isRemoteLoad && "tsfile".equalsIgnoreCase(fileType)) {
                ioTPrinter.println("host: " + host + " is remote load,only local load is supported in table model");
            }
        }
        catch (UnknownHostException e) {
            ioTPrinter.println("Unknown host: " + host + ". Exception: " + e.getMessage() + ". Will use local load.");
        }
        String os = commandLine.getOptionValue("os");
        String onSuccess = StringUtils.isNotBlank((CharSequence)os) ? os.trim().toLowerCase() : null;
        String of = commandLine.getOptionValue("of");
        String string = onFail = StringUtils.isNotBlank((CharSequence)of) ? of.trim().toLowerCase() : null;
        if (!(!"tsfile".equalsIgnoreCase(fileType) || ImportTsFileOperation.isValidOperation(onSuccess) && ImportTsFileOperation.isValidOperation(onFail))) {
            ioTPrinter.println("Args error: os/of must be one of none, mv, cp, delete");
            System.exit(1);
        }
        if ("tsfile".equalsIgnoreCase(fileType)) {
            boolean isSuccessDirEqualsSourceDir = false;
            if (ImportTsFileOperation.MV.name().equalsIgnoreCase(onSuccess) || ImportTsFileOperation.CP.name().equalsIgnoreCase(onSuccess)) {
                File dir = ImportData.createSuccessDir(commandLine);
                isSuccessDirEqualsSourceDir = ImportData.isFileStoreEquals(targetPath, dir);
            }
            boolean isFailDirEqualsSourceDir = false;
            if (ImportTsFileOperation.MV.name().equalsIgnoreCase(onFail) || ImportTsFileOperation.CP.name().equalsIgnoreCase(onFail)) {
                File dir = ImportData.createFailDir(commandLine);
                isFailDirEqualsSourceDir = ImportData.isFileStoreEquals(targetPath, dir);
            }
            successOperation = ImportTsFileOperation.getOperation(onSuccess, isSuccessDirEqualsSourceDir);
            failOperation = ImportTsFileOperation.getOperation(onFail, isFailDirEqualsSourceDir);
        }
        if (!sqlDialectTree && "csv".equalsIgnoreCase(fileType) && StringUtils.isBlank((CharSequence)table)) {
            ioTPrinter.println("Invalid args: Required values for option table not provided.");
            System.exit(1);
        }
    }

    public static boolean isFileStoreEquals(String pathString, File dir) {
        try {
            return Objects.equals(Files.getFileStore(Paths.get(pathString, new String[0])), Files.getFileStore(dir.toPath()));
        }
        catch (IOException e) {
            ioTPrinter.println("IOException when checking file store: " + e.getMessage());
            return false;
        }
    }

    public static File createSuccessDir(CommandLine commandLine) {
        File file;
        if (commandLine.getOptionValue("sd") != null) {
            successDir = commandLine.getOptionValue("sd");
        }
        if (!(file = new File(successDir)).isDirectory() && !file.mkdirs()) {
            ioTPrinter.println(String.format("Failed to create %s %s", "success_dir", successDir));
            System.exit(1);
        }
        return file;
    }

    public static File createFailDir(CommandLine commandLine) {
        File file;
        if (commandLine.getOptionValue("fd") != null) {
            failDir = commandLine.getOptionValue("fd");
        }
        if (!(file = new File(failDir)).isDirectory() && !file.mkdirs()) {
            ioTPrinter.println(String.format("Failed to create %s %s", "fail_dir", failDir));
            System.exit(1);
        }
        return file;
    }

    private static void applyTypeInferArgs(String key, String value) throws ArgsErrorException {
        if (!Constants.TYPE_INFER_KEY_DICT.containsKey(key)) {
            throw new ArgsErrorException("Unknown type infer key: " + key);
        }
        if (!Constants.TYPE_INFER_VALUE_DICT.containsKey(value)) {
            throw new ArgsErrorException("Unknown type infer value: " + value);
        }
        if (!(!key.equals("NaN") || value.equals("float") || value.equals("double") || value.equals("text") || value.equals("string"))) {
            throw new ArgsErrorException("NaN can not convert to " + value);
        }
        if (key.equals("boolean") && !value.equals("boolean") && !value.equals("text") && !value.equals("string")) {
            throw new ArgsErrorException("Boolean can not convert to " + value);
        }
        if (key.equals("date") && !value.equals("date") && !value.equals("text") && !value.equals("string")) {
            throw new ArgsErrorException("Date can not convert to " + value);
        }
        if (!(!key.equals("timestamp") || value.equals("timestamp") || value.equals("text") || value.equals("string") || value.equals("double") || value.equals("long"))) {
            throw new ArgsErrorException("Timestamp can not convert to " + value);
        }
        if (key.equals("blob") && !value.equals("blob")) {
            throw new ArgsErrorException("Blob can not convert to " + value);
        }
        TSDataType srcType = Constants.TYPE_INFER_VALUE_DICT.get(key);
        TSDataType dstType = Constants.TYPE_INFER_VALUE_DICT.get(value);
        if (dstType.getType() < srcType.getType()) {
            throw new ArgsErrorException(key + " can not convert to " + value);
        }
        Constants.TYPE_INFER_KEY_DICT.put(key, Constants.TYPE_INFER_VALUE_DICT.get(value));
    }

    private static int importFromTargetPathAsync() {
        try {
            AbstractImportData importData = sqlDialectTree ? new ImportDataTree() : new ImportDataTable();
            importData.init();
            File file = new File(targetPath);
            if (!file.isFile() && !file.isDirectory()) {
                ioTPrinter.println(String.format("Source file or directory %s does not exist", targetPath));
                System.exit(1);
            }
            AbstractImportData.init(importData);
            return 0;
        }
        catch (InterruptedException e) {
            ioTPrinter.println(String.format("Import tsfile fail: %s", e.getMessage()));
            Thread.currentThread().interrupt();
            return 1;
        }
        catch (Exception e) {
            ioTPrinter.println(String.format("Import tsfile fail: %s", e.getMessage()));
            return 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int importFromTargetPath(String host, int port, String username, String password, String targetPath, String timeZone) throws IoTDBConnectionException {
        block14: {
            try {
                session = new Session(host, port, username, password, false);
                session.open(false);
                timeZoneID = timeZone;
                ImportData.setTimeZone();
                File file = new File(targetPath);
                if (file.isFile()) {
                    if (file.getName().endsWith("sql")) {
                        ImportData.importFromSqlFile(session, file);
                    } else {
                        ImportData.importFromSingleFile(session, file);
                    }
                    break block14;
                }
                if (file.isDirectory()) {
                    File[] files = file.listFiles();
                    if (files == null) {
                        int n = 0;
                        return n;
                    }
                    for (File subFile : files) {
                        if (!subFile.isFile()) continue;
                        if (subFile.getName().endsWith("sql")) {
                            ImportData.importFromSqlFile(session, subFile);
                            continue;
                        }
                        ImportData.importFromSingleFile(session, subFile);
                    }
                    break block14;
                }
                ioTPrinter.println("File not found!");
                int n = 1;
                return n;
            }
            catch (IoTDBConnectionException | StatementExecutionException e) {
                ioTPrinter.println("Encounter an error when connecting to server, because " + e.getMessage());
                int n = 1;
                return n;
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }
        return 0;
    }

    private static void setTimeZone() throws IoTDBConnectionException, StatementExecutionException {
        if (timeZoneID != null) {
            session.setTimeZone(timeZoneID);
        }
        zoneId = ZoneId.of(session.getTimeZone());
    }

    private static void importFromSingleFile(Session session, File file) {
        block7: {
            if (file.getName().endsWith("csv") || file.getName().endsWith("txt")) {
                try {
                    CSVParser csvRecords = ImportData.readCsvFile(file.getAbsolutePath());
                    List headerNames = csvRecords.getHeaderNames();
                    Stream records = csvRecords.stream();
                    if (headerNames.isEmpty()) {
                        ioTPrinter.println("Empty file!");
                        return;
                    }
                    if (!timeColumn.equalsIgnoreCase(ImportData.filterBomHeader((String)headerNames.get(0)))) {
                        ioTPrinter.println("The first field of header must be `Time`!");
                        return;
                    }
                    String failedFilePath = null;
                    failedFilePath = failedFileDirectory == null ? file.getAbsolutePath() + ".failed" : failedFileDirectory + file.getName() + ".failed";
                    if (!deviceColumn.equalsIgnoreCase((String)headerNames.get(1))) {
                        ImportData.writeDataAlignedByTime(session, headerNames, records, failedFilePath);
                        break block7;
                    }
                    ImportData.writeDataAlignedByDevice(session, headerNames, records, failedFilePath);
                }
                catch (IOException | IllegalPathException e) {
                    ioTPrinter.println("CSV file read exception because: " + e.getMessage());
                }
            } else {
                ioTPrinter.println("The file name must end with \"csv\" or \"txt\"!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void importFromSqlFile(Session session, File file) {
        ArrayList<List<Object>> failedRecords = new ArrayList<List<Object>>();
        String failedFilePath = null;
        failedFilePath = failedFileDirectory == null ? file.getAbsolutePath() + ".failed" : failedFileDirectory + file.getName() + ".failed";
        try (BufferedReader br = new BufferedReader(new FileReader(file.getAbsolutePath()));){
            Object sql;
            while ((sql = br.readLine()) != null) {
                try {
                    session.executeNonQueryStatement((String)sql);
                }
                catch (IoTDBConnectionException | StatementExecutionException throwable) {
                    failedRecords.add(Arrays.asList(sql));
                }
            }
            ioTPrinter.println(file.getName() + " Import completely!");
        }
        catch (IOException e) {
            ioTPrinter.println("SQL file read exception because: " + e.getMessage());
        }
        if (!failedRecords.isEmpty()) {
            FileWriter writer = null;
            try {
                writer = new FileWriter(failedFilePath);
                for (List list : failedRecords) {
                    writer.write(list.get(0).toString() + "\n");
                }
            }
            catch (IOException e) {
                ioTPrinter.println("Cannot dump fail result because: " + e.getMessage());
            }
            finally {
                if (ObjectUtils.isNotEmpty((Object)writer)) {
                    try {
                        writer.flush();
                        writer.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }
}

