/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern.IrRowPattern;
import org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern.IrRowPatternVisitor;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class IrAnchor
extends IrRowPattern {
    private final Type type;

    public IrAnchor(Type type) {
        this.type = Objects.requireNonNull(type, "type is null");
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public <R, C> R accept(IrRowPatternVisitor<R, C> visitor, C context) {
        return visitor.visitIrAnchor(this, context);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        IrAnchor o = (IrAnchor)obj;
        return Objects.equals((Object)this.type, (Object)o.type);
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public String toString() {
        return this.type == Type.PARTITION_START ? "^" : "$";
    }

    public static void serialize(IrAnchor pattern, ByteBuffer byteBuffer) {
        ReadWriteIOUtils.write((int)pattern.type.ordinal(), (ByteBuffer)byteBuffer);
    }

    public static void serialize(IrAnchor pattern, DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((int)pattern.type.ordinal(), (OutputStream)stream);
    }

    public static IrAnchor deserialize(ByteBuffer byteBuffer) {
        Type type = Type.values()[ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer)];
        return new IrAnchor(type);
    }

    public static enum Type {
        PARTITION_START,
        PARTITION_END;

    }
}

