/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.read.common;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.tsfile.exception.PathParseException;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.read.common.parser.PathNodesGenerator;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class Path
implements Serializable,
Comparable<Path> {
    private static final long serialVersionUID = 3405277066329298200L;
    protected String measurement;
    protected IDeviceID device;
    protected String fullPath;
    private static final String ILLEGAL_PATH_ARGUMENT = "Path parameter is null";

    public Path() {
    }

    public Path(IDeviceID deviceID) {
        this.device = deviceID;
        this.fullPath = deviceID.toString();
    }

    public Path(String pathSc) {
        this(pathSc, false);
    }

    public Path(String pathSc, boolean needSplit) {
        if (pathSc == null) {
            throw new PathParseException(ILLEGAL_PATH_ARGUMENT);
        }
        if (!needSplit) {
            this.fullPath = pathSc;
            this.device = IDeviceID.Factory.DEFAULT_FACTORY.create(pathSc);
        } else if (pathSc.length() > 0) {
            String[] nodes = PathNodesGenerator.splitPathToNodes(pathSc);
            this.device = nodes.length > 1 ? IDeviceID.Factory.DEFAULT_FACTORY.create(this.transformNodesToString(nodes, nodes.length - 1)) : IDeviceID.Factory.DEFAULT_FACTORY.create("");
            this.measurement = nodes[nodes.length - 1];
            this.fullPath = this.device.toString() + "." + this.measurement;
        } else {
            this.fullPath = pathSc;
            this.device = IDeviceID.Factory.DEFAULT_FACTORY.create("");
            this.measurement = pathSc;
        }
    }

    public Path(IDeviceID device, String measurement, boolean needCheck) {
        this.device = device;
        this.measurement = measurement;
        this.fullPath = this.device.toString() + "." + measurement;
    }

    public Path(String device, String measurement, boolean needCheck) {
        if (device == null || measurement == null) {
            throw new PathParseException(ILLEGAL_PATH_ARGUMENT);
        }
        if (!needCheck) {
            this.measurement = measurement;
            this.device = IDeviceID.Factory.DEFAULT_FACTORY.create(device);
            this.fullPath = device + "." + measurement;
            return;
        }
        if (!StringUtils.isEmpty((CharSequence)device) && !StringUtils.isEmpty((CharSequence)measurement)) {
            String path = device + "." + measurement;
            String[] nodes = PathNodesGenerator.splitPathToNodes(path);
            this.device = IDeviceID.Factory.DEFAULT_FACTORY.create(this.transformNodesToString(nodes, nodes.length - 1));
            this.measurement = nodes[nodes.length - 1];
            this.fullPath = this.device.toString() + "." + measurement;
        } else if (!StringUtils.isEmpty((CharSequence)device)) {
            String[] deviceNodes = PathNodesGenerator.splitPathToNodes(device);
            this.device = IDeviceID.Factory.DEFAULT_FACTORY.create(this.transformNodesToString(deviceNodes, deviceNodes.length));
            this.measurement = measurement;
            this.fullPath = device + "." + measurement;
        } else if (!StringUtils.isEmpty((CharSequence)measurement)) {
            String[] measurementNodes = PathNodesGenerator.splitPathToNodes(measurement);
            this.measurement = this.transformNodesToString(measurementNodes, measurementNodes.length);
            this.device = IDeviceID.Factory.DEFAULT_FACTORY.create(device);
            this.fullPath = measurement;
        } else {
            this.device = IDeviceID.Factory.DEFAULT_FACTORY.create(device);
            this.measurement = measurement;
            this.fullPath = "";
        }
    }

    public String getFullPath() {
        return this.fullPath;
    }

    public String getDeviceString() {
        return this.device.toString();
    }

    public IDeviceID getIDeviceID() {
        return this.device;
    }

    public String getMeasurement() {
        return this.measurement;
    }

    public String getFullPathWithAlias() {
        throw new IllegalArgumentException("doesn't alias in TSFile Path");
    }

    public void setMeasurement(String measurement) {
        this.measurement = measurement;
    }

    public int hashCode() {
        return this.fullPath.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof Path && this.fullPath.equals(((Path)obj).fullPath);
    }

    public boolean equals(String obj) {
        return this.fullPath.equals(obj);
    }

    @Override
    public int compareTo(Path path) {
        return this.fullPath.compareTo(path.getFullPath());
    }

    public String toString() {
        return this.fullPath;
    }

    public Path clone() {
        return new Path(this.fullPath);
    }

    public int getColumnNum() {
        return 1;
    }

    public void serialize(ByteBuffer byteBuffer) {
        ReadWriteIOUtils.write((byte)3, byteBuffer);
        this.serializeWithoutType(byteBuffer);
    }

    public void serialize(OutputStream stream) throws IOException {
        ReadWriteIOUtils.write((byte)3, stream);
        this.serializeWithoutType(stream);
    }

    protected void serializeWithoutType(ByteBuffer byteBuffer) {
        if (this.measurement == null) {
            ReadWriteIOUtils.write((byte)0, byteBuffer);
        } else {
            ReadWriteIOUtils.write((byte)1, byteBuffer);
            ReadWriteIOUtils.write(this.measurement, byteBuffer);
        }
        if (this.device == null) {
            ReadWriteIOUtils.write((byte)0, byteBuffer);
        } else {
            ReadWriteIOUtils.write((byte)1, byteBuffer);
            this.device.serialize(byteBuffer);
        }
        if (this.fullPath == null) {
            ReadWriteIOUtils.write((byte)0, byteBuffer);
        } else {
            ReadWriteIOUtils.write((byte)1, byteBuffer);
            ReadWriteIOUtils.write(this.fullPath, byteBuffer);
        }
    }

    protected void serializeWithoutType(OutputStream stream) throws IOException {
        if (this.measurement == null) {
            ReadWriteIOUtils.write((byte)0, stream);
        } else {
            ReadWriteIOUtils.write((byte)1, stream);
            ReadWriteIOUtils.write(this.measurement, stream);
        }
        if (this.device == null) {
            ReadWriteIOUtils.write((byte)0, stream);
        } else {
            ReadWriteIOUtils.write((byte)1, stream);
            this.device.serialize(stream);
        }
        if (this.fullPath == null) {
            ReadWriteIOUtils.write((byte)0, stream);
        } else {
            ReadWriteIOUtils.write((byte)1, stream);
            ReadWriteIOUtils.write(this.fullPath, stream);
        }
    }

    public static Path deserialize(ByteBuffer byteBuffer) {
        Path path = new Path();
        byte isNull = ReadWriteIOUtils.readByte(byteBuffer);
        path.measurement = isNull == 0 ? null : ReadWriteIOUtils.readString(byteBuffer);
        isNull = ReadWriteIOUtils.readByte(byteBuffer);
        path.device = isNull == 0 ? null : IDeviceID.Deserializer.DEFAULT_DESERIALIZER.deserializeFrom(byteBuffer);
        isNull = ReadWriteIOUtils.readByte(byteBuffer);
        path.fullPath = isNull == 0 ? null : ReadWriteIOUtils.readString(byteBuffer);
        return path;
    }

    private String transformNodesToString(String[] nodes, int index) {
        Validate.isTrue((nodes.length > 0 ? 1 : 0) != 0);
        StringBuilder s = new StringBuilder(nodes[0]);
        for (int i = 1; i < index; ++i) {
            s.append(".");
            s.append(nodes[i]);
        }
        return s.toString();
    }
}

