/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.dataset.groupby;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.engine.storagegroup.VirtualStorageGroupProcessor;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.path.AlignedPath;
import org.apache.iotdb.db.metadata.path.MeasurementPath;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.metadata.utils.MetaUtils;
import org.apache.iotdb.db.qp.physical.crud.GroupByTimePlan;
import org.apache.iotdb.db.qp.physical.crud.RawDataQueryPlan;
import org.apache.iotdb.db.query.aggregation.AggregateResult;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.control.QueryResourceManager;
import org.apache.iotdb.db.query.dataset.groupby.GroupByEngineDataSet;
import org.apache.iotdb.db.query.factory.AggregateResultFactory;
import org.apache.iotdb.db.query.reader.series.IReaderByTimestamp;
import org.apache.iotdb.db.query.reader.series.SeriesReaderByTimestamp;
import org.apache.iotdb.db.query.timegenerator.ServerTimeGenerator;
import org.apache.iotdb.db.utils.QueryUtils;
import org.apache.iotdb.db.utils.ValueIterator;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.iotdb.tsfile.read.filter.TimeFilter;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.filter.factory.FilterFactory;
import org.apache.iotdb.tsfile.read.filter.operator.AndFilter;
import org.apache.iotdb.tsfile.read.query.timegenerator.TimeGenerator;
import org.apache.iotdb.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupByWithValueFilterDataSet
extends GroupByEngineDataSet {
    private static final Logger logger = LoggerFactory.getLogger(GroupByWithValueFilterDataSet.class);
    private Map<IReaderByTimestamp, List<List<Integer>>> readerToAggrIndexesMap;
    protected GroupByTimePlan groupByTimePlan;
    private TimeGenerator timestampGenerator;
    private LinkedList<Long> cachedTimestamps = new LinkedList();
    protected int timeStampFetchSize;
    private long lastTimestamp;

    protected GroupByWithValueFilterDataSet() {
    }

    public GroupByWithValueFilterDataSet(QueryContext context, GroupByTimePlan groupByTimePlan) {
        super(context, groupByTimePlan);
        this.timeStampFetchSize = IoTDBDescriptor.getInstance().getConfig().getBatchSize();
    }

    public GroupByWithValueFilterDataSet(long queryId, GroupByTimePlan groupByTimePlan) {
        super(new QueryContext(queryId), groupByTimePlan);
        this.readerToAggrIndexesMap = new HashMap<IReaderByTimestamp, List<List<Integer>>>();
        this.timeStampFetchSize = IoTDBDescriptor.getInstance().getConfig().getBatchSize();
    }

    public void initGroupBy(QueryContext context, GroupByTimePlan groupByTimePlan) throws StorageEngineException, QueryProcessException {
        IReaderByTimestamp seriesReaderByTimestamp;
        this.timestampGenerator = this.getTimeGenerator(context, groupByTimePlan);
        this.readerToAggrIndexesMap = new HashMap<IReaderByTimestamp, List<List<Integer>>>();
        this.groupByTimePlan = groupByTimePlan;
        AndFilter timeFilter = FilterFactory.and((Filter)TimeFilter.gtEq((long)groupByTimePlan.getStartTime()), (Filter)TimeFilter.lt((long)groupByTimePlan.getEndTime()));
        ArrayList selectedSeries = new ArrayList();
        groupByTimePlan.getDeduplicatedPaths().forEach(k -> selectedSeries.add(((MeasurementPath)k).transformToExactPath()));
        Map<PartialPath, List<Integer>> pathToAggrIndexesMap = MetaUtils.groupAggregationsBySeries(selectedSeries);
        Map<AlignedPath, List<List<Integer>>> alignedPathToAggrIndexesMap = MetaUtils.groupAlignedSeriesWithAggregations(pathToAggrIndexesMap);
        ArrayList<PartialPath> groupedPathList = new ArrayList<PartialPath>(pathToAggrIndexesMap.size() + alignedPathToAggrIndexesMap.size());
        groupedPathList.addAll(pathToAggrIndexesMap.keySet());
        groupedPathList.addAll(alignedPathToAggrIndexesMap.keySet());
        Pair<List<VirtualStorageGroupProcessor>, Map<VirtualStorageGroupProcessor, List<PartialPath>>> lockListAndProcessorToSeriesMapPair = StorageEngine.getInstance().mergeLock(groupedPathList);
        List lockList = (List)lockListAndProcessorToSeriesMapPair.left;
        Map processorToSeriesMap = (Map)lockListAndProcessorToSeriesMapPair.right;
        try {
            QueryResourceManager.getInstance().initQueryDataSourceCache(processorToSeriesMap, context, (Filter)timeFilter);
        }
        catch (Exception e) {
            logger.error("Meet error when init QueryDataSource ", (Throwable)e);
            throw new QueryProcessException("Meet error when init QueryDataSource.", e);
        }
        finally {
            StorageEngine.getInstance().mergeUnLock(lockList);
        }
        for (PartialPath partialPath : pathToAggrIndexesMap.keySet()) {
            seriesReaderByTimestamp = this.getReaderByTime(partialPath, groupByTimePlan, context);
            this.readerToAggrIndexesMap.put(seriesReaderByTimestamp, Collections.singletonList(pathToAggrIndexesMap.get(partialPath)));
        }
        pathToAggrIndexesMap = null;
        for (PartialPath partialPath : alignedPathToAggrIndexesMap.keySet()) {
            seriesReaderByTimestamp = this.getReaderByTime(partialPath, groupByTimePlan, context);
            this.readerToAggrIndexesMap.put(seriesReaderByTimestamp, alignedPathToAggrIndexesMap.get(partialPath));
        }
        alignedPathToAggrIndexesMap = null;
    }

    protected TimeGenerator getTimeGenerator(QueryContext context, RawDataQueryPlan queryPlan) throws StorageEngineException {
        return new ServerTimeGenerator(context, queryPlan);
    }

    protected IReaderByTimestamp getReaderByTime(PartialPath path, RawDataQueryPlan queryPlan, QueryContext context) throws StorageEngineException, QueryProcessException {
        return new SeriesReaderByTimestamp(path, queryPlan.getAllMeasurementsInDevice(path.getDevice()), path.getSeriesType(), context, QueryResourceManager.getInstance().getQueryDataSource(path, context, null, queryPlan.isAscending()), null, this.ascending);
    }

    @Override
    public RowRecord nextWithoutConstraint() throws IOException {
        if (!this.hasCachedTimeInterval) {
            throw new IOException("need to call hasNext() before calling next() in GroupByWithValueFilterDataSet.");
        }
        this.hasCachedTimeInterval = false;
        this.curAggregateResults = new AggregateResult[this.paths.size()];
        for (int i = 0; i < this.paths.size(); ++i) {
            this.curAggregateResults[i] = AggregateResultFactory.getAggrResultByName(this.groupByTimePlan.getDeduplicatedAggregations().get(i), this.groupByTimePlan.getDeduplicatedDataTypes().get(i), this.ascending);
        }
        long[] timestampArray = new long[this.timeStampFetchSize];
        int timeArrayLength = 0;
        if (!this.cachedTimestamps.isEmpty()) {
            long timestamp = this.cachedTimestamps.remove();
            if (timestamp < this.curEndTime) {
                if (!this.groupByTimePlan.isAscending() && timestamp < this.curStartTime) {
                    this.cachedTimestamps.addFirst(timestamp);
                    return this.constructRowRecord(this.curAggregateResults);
                }
                if (timestamp >= this.curStartTime) {
                    timestampArray[timeArrayLength++] = timestamp;
                }
            } else {
                this.cachedTimestamps.addFirst(timestamp);
                return this.constructRowRecord(this.curAggregateResults);
            }
        }
        while (!this.cachedTimestamps.isEmpty() || this.timestampGenerator.hasNext()) {
            timeArrayLength = this.constructTimeArrayForOneCal(timestampArray, timeArrayLength);
            this.calcUsingTimestampArray(timestampArray, timeArrayLength);
            timeArrayLength = 0;
            if ((!this.groupByTimePlan.isAscending() || this.lastTimestamp < this.curEndTime) && (this.groupByTimePlan.isAscending() || this.lastTimestamp >= this.curStartTime)) continue;
        }
        if (timeArrayLength > 0) {
            this.calcUsingTimestampArray(timestampArray, timeArrayLength);
        }
        return this.constructRowRecord(this.curAggregateResults);
    }

    private void calcUsingTimestampArray(long[] timestampArray, int timeArrayLength) throws IOException {
        for (Map.Entry<IReaderByTimestamp, List<List<Integer>>> entry : this.readerToAggrIndexesMap.entrySet()) {
            IReaderByTimestamp reader = entry.getKey();
            List<List<Integer>> subIndexes = entry.getValue();
            int subSensorSize = subIndexes.size();
            Object[] values = reader.getValuesInTimestamps(timestampArray, timeArrayLength);
            ValueIterator valueIterator = QueryUtils.generateValueIterator(values);
            if (valueIterator == null) continue;
            for (int curIndex = 0; curIndex < subSensorSize; ++curIndex) {
                valueIterator.setSubMeasurementIndex(curIndex);
                for (Integer index : subIndexes.get(curIndex)) {
                    this.curAggregateResults[index].updateResultUsingValues(timestampArray, timeArrayLength, valueIterator);
                    valueIterator.reset();
                }
            }
        }
    }

    private int constructTimeArrayForOneCal(long[] timestampArray, int timeArrayLength) throws IOException {
        for (int cnt = 1; cnt < this.timeStampFetchSize - 1 && (!this.cachedTimestamps.isEmpty() || this.timestampGenerator.hasNext()); ++cnt) {
            this.lastTimestamp = !this.cachedTimestamps.isEmpty() ? this.cachedTimestamps.remove().longValue() : this.timestampGenerator.next();
            if (this.groupByTimePlan.isAscending() && this.lastTimestamp < this.curEndTime) {
                timestampArray[timeArrayLength++] = this.lastTimestamp;
                continue;
            }
            if (!this.groupByTimePlan.isAscending() && this.lastTimestamp >= this.curStartTime) {
                timestampArray[timeArrayLength++] = this.lastTimestamp;
                continue;
            }
            if (!this.cachedTimestamps.isEmpty() && this.lastTimestamp <= this.cachedTimestamps.peek()) {
                this.cachedTimestamps.addFirst(this.lastTimestamp);
                break;
            }
            this.cachedTimestamps.add(this.lastTimestamp);
            break;
        }
        return timeArrayLength;
    }

    private RowRecord constructRowRecord(AggregateResult[] aggregateResultList) {
        RowRecord record = this.leftCRightO ? new RowRecord(this.curStartTime) : new RowRecord(this.curEndTime - 1L);
        for (int i = 0; i < this.paths.size(); ++i) {
            AggregateResult aggregateResult = aggregateResultList[i];
            record.addField(aggregateResult.getResult(), aggregateResult.getResultDataType());
        }
        return record;
    }
}

