/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.table;

import java.util.Objects;
import org.apache.ignite3.compute.JobExecutorType;

public class ReceiverExecutionOptions {
    public static final ReceiverExecutionOptions DEFAULT = ReceiverExecutionOptions.builder().priority(0).maxRetries(0).build();
    private final int priority;
    private final int maxRetries;
    private final JobExecutorType executorType;

    private ReceiverExecutionOptions(int priority, int maxRetries, JobExecutorType executorType) {
        this.priority = priority;
        this.maxRetries = maxRetries;
        this.executorType = executorType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public int priority() {
        return this.priority;
    }

    public int maxRetries() {
        return this.maxRetries;
    }

    public JobExecutorType executorType() {
        return this.executorType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.priority, this.maxRetries, this.executorType});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ReceiverExecutionOptions other = (ReceiverExecutionOptions)obj;
        return this.priority == other.priority && this.maxRetries == other.maxRetries && this.executorType == other.executorType;
    }

    public static class Builder {
        private int priority;
        private int maxRetries;
        private JobExecutorType executorType = JobExecutorType.JAVA_EMBEDDED;

        public Builder priority(int priority) {
            this.priority = priority;
            return this;
        }

        public Builder maxRetries(int maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public Builder executorType(JobExecutorType jobExecutorType) {
            this.executorType = jobExecutorType;
            return this;
        }

        public ReceiverExecutionOptions build() {
            return new ReceiverExecutionOptions(this.priority, this.maxRetries, this.executorType);
        }
    }
}

