/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.pagememory.inmemory;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.ignite3.internal.lang.IgniteInternalException;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.pagememory.PageMemory;
import org.apache.ignite3.internal.pagememory.configuration.VolatileDataRegionConfiguration;
import org.apache.ignite3.internal.pagememory.io.PageIo;
import org.apache.ignite3.internal.pagememory.io.PageIoRegistry;
import org.apache.ignite3.internal.pagememory.mem.DirectMemoryProvider;
import org.apache.ignite3.internal.pagememory.mem.DirectMemoryRegion;
import org.apache.ignite3.internal.pagememory.mem.IgniteOutOfMemoryException;
import org.apache.ignite3.internal.pagememory.mem.unsafe.UnsafeMemoryProvider;
import org.apache.ignite3.internal.pagememory.util.PageIdUtils;
import org.apache.ignite3.internal.util.GridUnsafe;
import org.apache.ignite3.internal.util.IgniteUtils;
import org.apache.ignite3.internal.util.OffheapReadWriteLock;
import org.apache.ignite3.internal.util.StringUtils;

public class VolatilePageMemory
implements PageMemory {
    private static final IgniteLogger LOG = Loggers.forClass(VolatilePageMemory.class);
    public static final long PAGE_MARKER = -4689742691020378367L;
    private static final long RELATIVE_PTR_MASK = 0xFFFFFFFFFFFFFFL;
    private static final long INVALID_REL_PTR = 0xFFFFFFFFFFFFFFL;
    private static final long ADDRESS_MASK = 0xFFFFFFFFFFFFFFL;
    private static final long COUNTER_MASK = -72057594037927936L;
    private static final long COUNTER_INC = 0x100000000000000L;
    public static final int PAGE_ID_OFFSET = 8;
    public static final int LOCK_OFFSET = 16;
    public static final int PAGE_OVERHEAD = 24;
    private static final int SEG_BITS = 4;
    private static final int SEG_CNT = 16;
    private static final int IDX_BITS = 28;
    private static final int SEG_MASK = 15;
    private static final int IDX_MASK = 0xFFFFFFF;
    private final int sysPageSize;
    private final DirectMemoryProvider directMemoryProvider;
    private final VolatileDataRegionConfiguration dataRegionConfiguration;
    private final AtomicLong freePageListHead = new AtomicLong(0xFFFFFFFFFFFFFFL);
    private volatile Segment[] segments;
    private final Object segmentsLock = new Object();
    private final AtomicInteger allocatedPages = new AtomicInteger();
    private final OffheapReadWriteLock rwLock;
    private final int totalPages;
    private final boolean trackAcquiredPages;
    private final PageIoRegistry ioRegistry;
    private volatile boolean started;

    public VolatilePageMemory(VolatileDataRegionConfiguration dataRegionConfiguration, PageIoRegistry ioRegistry, OffheapReadWriteLock rwLock) {
        this.ioRegistry = ioRegistry;
        this.trackAcquiredPages = false;
        this.dataRegionConfiguration = dataRegionConfiguration;
        this.directMemoryProvider = new UnsafeMemoryProvider(null);
        this.sysPageSize = dataRegionConfiguration.pageSize() + 24;
        assert (this.sysPageSize % 8 == 0) : this.sysPageSize;
        this.totalPages = (int)(this.dataRegionConfiguration.maxSizeBytes() / (long)this.sysPageSize);
        this.rwLock = rwLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws IgniteInternalException {
        Object object = this.segmentsLock;
        synchronized (object) {
            long allocSize;
            if (this.started) {
                return;
            }
            this.started = true;
            long startSize = this.dataRegionConfiguration.initSizeBytes();
            long maxSize = this.dataRegionConfiguration.maxSizeBytes();
            long[] chunks = new long[16];
            chunks[0] = startSize;
            long total = startSize;
            long allocChunkSize = Math.max((maxSize - startSize) / 15L, 0x10000000L);
            int lastIdx = 0;
            int i = 1;
            while (i < 16 && (allocSize = Math.min(allocChunkSize, maxSize - total)) > 0L) {
                chunks[i] = allocSize;
                total += allocSize;
                lastIdx = i++;
            }
            if (lastIdx != 15) {
                chunks = Arrays.copyOf(chunks, lastIdx + 1);
            }
            if (this.segments == null) {
                this.directMemoryProvider.initialize(chunks);
            }
            this.addSegment(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(boolean deallocate) throws IgniteInternalException {
        Object object = this.segmentsLock;
        synchronized (object) {
            LOG.debug("Stopping page memory", new Object[0]);
            this.started = false;
            this.directMemoryProvider.shutdown(deallocate);
            if (this.directMemoryProvider instanceof Closeable) {
                try {
                    ((Closeable)((Object)this.directMemoryProvider)).close();
                }
                catch (IOException e) {
                    throw new IgniteInternalException(e);
                }
            }
        }
    }

    @Override
    public ByteBuffer pageBuffer(long pageAddr) {
        return GridUnsafe.wrapPointer(pageAddr, this.pageSize());
    }

    @Override
    public long allocatePageNoReuse(int grpId, int partId, byte flags) {
        assert (this.started);
        long relPtr = this.borrowFreePage();
        long absPtr = 0L;
        if (relPtr != 0xFFFFFFFFFFFFFFL) {
            int pageIdx = PageIdUtils.pageIndex(relPtr);
            Segment seg = this.segment(pageIdx);
            absPtr = seg.absolute(pageIdx);
        } else {
            Segment[] seg0 = this.segments;
            Segment allocSeg = seg0[seg0.length - 1];
            while (allocSeg != null) {
                relPtr = allocSeg.allocateFreePage(flags);
                if (relPtr != 0xFFFFFFFFFFFFFFL) {
                    absPtr = allocSeg.absolute(PageIdUtils.pageIndex(relPtr));
                    this.allocatedPages.incrementAndGet();
                    break;
                }
                allocSeg = this.addSegment(seg0);
            }
        }
        if (relPtr == 0xFFFFFFFFFFFFFFL) {
            IgniteOutOfMemoryException oom = new IgniteOutOfMemoryException("Out of memory in data region [name=" + this.dataRegionConfiguration.name() + ", initSize=" + IgniteUtils.readableSize(this.dataRegionConfiguration.initSizeBytes(), false) + ", maxSize=" + IgniteUtils.readableSize(this.dataRegionConfiguration.maxSizeBytes(), false) + ", persistence=false] Try the following:" + System.lineSeparator() + "  ^-- Increase maximum off-heap memory size" + System.lineSeparator() + "  ^-- Use persistence" + System.lineSeparator() + "  ^-- Enable eviction or expiration policies");
            throw oom;
        }
        assert ((relPtr & 0xFFFFFFFF00000000L) == 0L) : StringUtils.hexLong(relPtr & 0xFFFFFFFF00000000L);
        long pageId = PageIdUtils.pageId(partId, flags, (int)relPtr);
        this.writePageId(absPtr, pageId);
        GridUnsafe.zeroMemory(absPtr + 24L, this.sysPageSize - 24);
        return pageId;
    }

    @Override
    public boolean freePage(int grpId, long pageId) {
        assert (this.started);
        this.releaseFreePage(pageId);
        return true;
    }

    @Override
    public int pageSize() {
        return this.sysPageSize - 24;
    }

    @Override
    public int systemPageSize() {
        return this.sysPageSize;
    }

    @Override
    public int realPageSize(int grpId) {
        return this.pageSize();
    }

    @Override
    public long loadedPages() {
        return this.allocatedPages.get();
    }

    public int totalPages() {
        return this.totalPages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long acquiredPages() {
        long total = 0L;
        for (Segment seg : this.segments) {
            seg.readLock().lock();
            try {
                int acquired = seg.acquiredPages();
                assert (acquired >= 0);
                total += (long)acquired;
            }
            finally {
                seg.readLock().unlock();
            }
        }
        return total;
    }

    private void writePageId(long absPtr, long pageId) {
        GridUnsafe.putLong(absPtr + 8L, pageId);
    }

    private Segment segment(int pageIdx) {
        int segIdx = this.segmentIndex(pageIdx);
        return this.segments[segIdx];
    }

    private int segmentIndex(long pageIdx) {
        return (int)(pageIdx >> 28 & 0xFL);
    }

    private long fromSegmentIndex(int segIdx, long pageIdx) {
        long res = 0L;
        res = res << 4 | (long)(segIdx & 0xF);
        res = res << 28 | pageIdx & 0xFFFFFFFL;
        return res;
    }

    @Override
    public long acquirePage(int cacheId, long pageId) {
        assert (this.started);
        int pageIdx = PageIdUtils.pageIndex(pageId);
        Segment seg = this.segment(pageIdx);
        return seg.acquirePage(pageIdx);
    }

    @Override
    public void releasePage(int cacheId, long pageId, long page) {
        assert (this.started);
        if (this.trackAcquiredPages) {
            Segment seg = this.segment(PageIdUtils.pageIndex(pageId));
            seg.onPageRelease();
        }
    }

    @Override
    public long readLock(int cacheId, long pageId, long page) {
        assert (this.started);
        if (this.rwLock.readLock(page + 16L, PageIdUtils.tag(pageId))) {
            return page + 24L;
        }
        return 0L;
    }

    @Override
    public long readLockForce(int cacheId, long pageId, long page) {
        assert (this.started);
        if (this.rwLock.readLock(page + 16L, -1)) {
            return page + 24L;
        }
        return 0L;
    }

    @Override
    public void readUnlock(int cacheId, long pageId, long page) {
        assert (this.started);
        this.rwLock.readUnlock(page + 16L);
    }

    @Override
    public long writeLock(int cacheId, long pageId, long page) {
        assert (this.started);
        if (this.rwLock.writeLock(page + 16L, PageIdUtils.tag(pageId))) {
            return page + 24L;
        }
        return 0L;
    }

    @Override
    public long tryWriteLock(int cacheId, long pageId, long page) {
        assert (this.started);
        if (this.rwLock.tryWriteLock(page + 16L, PageIdUtils.tag(pageId))) {
            return page + 24L;
        }
        return 0L;
    }

    @Override
    public void writeUnlock(int cacheId, long pageId, long page, boolean dirtyFlag) {
        assert (this.started);
        long actualId = PageIo.getPageId(page + 24L);
        this.rwLock.writeUnlock(page + 16L, PageIdUtils.tag(actualId));
    }

    @Override
    public boolean isDirty(int cacheId, long pageId, long page) {
        return false;
    }

    @Override
    public PageIoRegistry ioRegistry() {
        return this.ioRegistry;
    }

    public int pageSequenceNumber(int pageIdx) {
        Segment seg = this.segment(pageIdx);
        return seg.sequenceNumber(pageIdx);
    }

    public int pageIndex(int seqNo) {
        Object[] segs = this.segments;
        int low = 0;
        int high = segs.length - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            Object seg = segs[mid];
            int cmp = ((Segment)seg).containsPageBySequence(seqNo);
            if (cmp < 0) {
                high = mid - 1;
                continue;
            }
            if (cmp > 0) {
                low = mid + 1;
                continue;
            }
            return ((Segment)seg).pageIndex(seqNo);
        }
        throw new IgniteInternalException("Allocated page must always be present in one of the segments [seqNo=" + seqNo + ", segments=" + Arrays.toString(segs) + "]");
    }

    private void releaseFreePage(long pageId) {
        long freePageRelPtrMasked;
        int pageIdx = PageIdUtils.pageIndex(pageId);
        long relPtr = PageIdUtils.pageId(0, (byte)0, pageIdx);
        Segment seg = this.segment(pageIdx);
        long absPtr = seg.absolute(pageIdx);
        this.writePageId(absPtr, relPtr);
        do {
            freePageRelPtrMasked = this.freePageListHead.get();
            long freePageRelPtr = freePageRelPtrMasked & 0xFFFFFFFFFFFFFFL;
            GridUnsafe.putLong(absPtr, freePageRelPtr);
        } while (!this.freePageListHead.compareAndSet(freePageRelPtrMasked, relPtr));
        this.allocatedPages.decrementAndGet();
    }

    private long borrowFreePage() {
        long cnt;
        long freePageRelPtr;
        int pageIdx;
        Segment seg;
        long freePageAbsPtr;
        long nextFreePageRelPtr;
        long freePageRelPtrMasked;
        do {
            if ((freePageRelPtr = (freePageRelPtrMasked = this.freePageListHead.get()) & 0xFFFFFFFFFFFFFFL) != 0xFFFFFFFFFFFFFFL) continue;
            return 0xFFFFFFFFFFFFFFL;
        } while (!this.freePageListHead.compareAndSet(freePageRelPtrMasked, (nextFreePageRelPtr = GridUnsafe.getLong(freePageAbsPtr = (seg = this.segment(pageIdx = PageIdUtils.pageIndex(freePageRelPtr))).absolute(pageIdx)) & 0xFFFFFFFFFFFFFFL) | (cnt = (freePageRelPtrMasked & 0xFF00000000000000L) + 0x100000000000000L & 0xFF00000000000000L)));
        GridUnsafe.putLong(freePageAbsPtr, -4689742691020378367L);
        this.allocatedPages.incrementAndGet();
        return freePageRelPtr;
    }

    private synchronized Segment addSegment(Segment[] oldRef) {
        if (this.segments == oldRef) {
            DirectMemoryRegion region = this.directMemoryProvider.nextRegion();
            if (region == null) {
                return null;
            }
            if (oldRef != null && LOG.isInfoEnabled()) {
                LOG.info("Allocated next memory segment for region [name={}, size={}]", this.dataRegionConfiguration.name(), IgniteUtils.readableSize(region.size(), true));
            }
            Segment[] newRef = new Segment[oldRef == null ? 1 : oldRef.length + 1];
            if (oldRef != null) {
                System.arraycopy(oldRef, 0, newRef, 0, oldRef.length);
            }
            Segment lastSeg = oldRef == null ? null : oldRef[oldRef.length - 1];
            Segment allocated = new Segment(newRef.length - 1, region, lastSeg == null ? 0 : lastSeg.sumPages());
            allocated.init();
            newRef[newRef.length - 1] = allocated;
            this.segments = newRef;
        }
        return this.segments[this.segments.length - 1];
    }

    private class Segment
    extends ReentrantReadWriteLock {
        private static final long serialVersionUID = 0L;
        private final int idx;
        private final DirectMemoryRegion region;
        private long lastAllocatedIdxPtr;
        private long pagesBase;
        private final int pagesInPrevSegments;
        private int maxPages;
        private final AtomicInteger acquiredPages;

        private Segment(int idx, DirectMemoryRegion region, int pagesInPrevSegments) {
            this.idx = idx;
            this.region = region;
            this.pagesInPrevSegments = pagesInPrevSegments;
            this.acquiredPages = new AtomicInteger();
        }

        private void init() {
            long base;
            this.lastAllocatedIdxPtr = base = this.region.address();
            this.pagesBase = (base += 8L) + 7L & 0xFFFFFFFFFFFFFFF8L;
            GridUnsafe.putLong(this.lastAllocatedIdxPtr, 0L);
            long limit = this.region.address() + this.region.size();
            this.maxPages = (int)((limit - this.pagesBase) / (long)VolatilePageMemory.this.sysPageSize);
        }

        private long acquirePage(int pageIdx) {
            long absPtr = this.absolute(pageIdx);
            assert (absPtr % 8L == 0L) : absPtr;
            if (VolatilePageMemory.this.trackAcquiredPages) {
                this.acquiredPages.incrementAndGet();
            }
            return absPtr;
        }

        private void onPageRelease() {
            this.acquiredPages.decrementAndGet();
        }

        private long absolute(int pageIdx) {
            long off = (long)(pageIdx &= 0xFFFFFFF) * (long)VolatilePageMemory.this.sysPageSize;
            return this.pagesBase + off;
        }

        private int sequenceNumber(int pageIdx) {
            return this.pagesInPrevSegments + (pageIdx &= 0xFFFFFFF);
        }

        private int sumPages() {
            return this.pagesInPrevSegments + this.maxPages;
        }

        private int acquiredPages() {
            return this.acquiredPages.get();
        }

        private long allocateFreePage(int tag) {
            long lastIdx;
            long limit = this.region.address() + this.region.size();
            do {
                if (this.pagesBase + ((lastIdx = GridUnsafe.getLongVolatile(null, this.lastAllocatedIdxPtr)) + 1L) * (long)VolatilePageMemory.this.sysPageSize <= limit) continue;
                return 0xFFFFFFFFFFFFFFL;
            } while (!GridUnsafe.compareAndSwapLong(null, this.lastAllocatedIdxPtr, lastIdx, lastIdx + 1L));
            long absPtr = this.pagesBase + lastIdx * (long)VolatilePageMemory.this.sysPageSize;
            assert (lastIdx <= 0xFFFFFFFFL) : lastIdx;
            long pageIdx = VolatilePageMemory.this.fromSegmentIndex(this.idx, lastIdx);
            assert (pageIdx != 0xFFFFFFFFFFFFFFL);
            VolatilePageMemory.this.writePageId(absPtr, pageIdx);
            GridUnsafe.putLong(absPtr, -4689742691020378367L);
            VolatilePageMemory.this.rwLock.init(absPtr + 16L, tag);
            return pageIdx;
        }

        public int containsPageBySequence(int seqNo) {
            if (seqNo < this.pagesInPrevSegments) {
                return -1;
            }
            if (seqNo < this.pagesInPrevSegments + this.maxPages) {
                return 0;
            }
            return 1;
        }

        public int pageIndex(int seqNo) {
            return PageIdUtils.pageIndex(VolatilePageMemory.this.fromSegmentIndex(this.idx, seqNo - this.pagesInPrevSegments));
        }
    }
}

