/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.metastorage.dsl;

import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.ignite3.internal.metastorage.dsl.ConditionType;
import org.apache.ignite3.internal.metastorage.dsl.RevisionConditionBuilder;
import org.apache.ignite3.internal.metastorage.dsl.RevisionConditionSerializer;
import org.apache.ignite3.internal.metastorage.dsl.SimpleCondition;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.tostring.IgniteToStringInclude;
import org.apache.ignite3.internal.tostring.S;

public class RevisionConditionImpl
implements SimpleCondition.RevisionCondition,
Cloneable {
    public static final short GROUP_TYPE = 222;
    public static final short TYPE = 2;
    @IgniteToStringInclude
    private final ByteBuffer key;
    @IgniteToStringInclude
    private final long revision;
    @IgniteToStringInclude
    private final ConditionType type;

    private RevisionConditionImpl(ByteBuffer key, long revision, ConditionType type) {
        this.key = key;
        this.revision = revision;
        this.type = type;
    }

    @Override
    public ByteBuffer key() {
        return this.key;
    }

    @Override
    public long revision() {
        return this.revision;
    }

    @Override
    public ConditionType type() {
        return this.type;
    }

    public MessageSerializer serializer() {
        return RevisionConditionSerializer.INSTANCE;
    }

    @Override
    public short groupType() {
        return 222;
    }

    public String toString() {
        return S.toString(RevisionConditionImpl.class, this);
    }

    @Override
    public short messageType() {
        return 2;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        RevisionConditionImpl otherMessage = (RevisionConditionImpl)other;
        return Objects.equals(this.key, otherMessage.key) && Objects.equals((Object)this.type, (Object)otherMessage.type) && this.revision == otherMessage.revision;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(new Object[]{this.revision, this.key, this.type});
        return result;
    }

    @Override
    public RevisionConditionImpl clone() {
        try {
            return (RevisionConditionImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static RevisionConditionBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements RevisionConditionBuilder {
        private ByteBuffer key;
        private long revision;
        private ConditionType type;

        private Builder() {
        }

        @Override
        public RevisionConditionBuilder key(ByteBuffer key) {
            Objects.requireNonNull(key, "key is not marked @Nullable");
            this.key = key;
            return this;
        }

        @Override
        public RevisionConditionBuilder revision(long revision) {
            this.revision = revision;
            return this;
        }

        @Override
        public RevisionConditionBuilder type(ConditionType type) {
            Objects.requireNonNull(type, "type is not marked @Nullable");
            this.type = type;
            return this;
        }

        @Override
        public ByteBuffer key() {
            return this.key;
        }

        @Override
        public long revision() {
            return this.revision;
        }

        @Override
        public ConditionType type() {
            return this.type;
        }

        @Override
        public SimpleCondition.RevisionCondition build() {
            return new RevisionConditionImpl(Objects.requireNonNull(this.key, "key is not marked @Nullable"), this.revision, Objects.requireNonNull(this.type, "type is not marked @Nullable"));
        }
    }
}

