/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cluster.management;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.ignite3.internal.cluster.management.ClusterState;
import org.apache.ignite3.internal.cluster.management.ClusterTag;
import org.apache.ignite3.internal.cluster.management.network.messages.CmgMessagesFactory;
import org.apache.ignite3.internal.util.io.IgniteDataInput;
import org.apache.ignite3.internal.util.io.IgniteDataOutput;
import org.apache.ignite3.internal.versioned.VersionedSerializer;
import org.jetbrains.annotations.Nullable;

public class ClusterStatePersistentSerializer
extends VersionedSerializer<ClusterState> {
    private static final CmgMessagesFactory CMG_MSGS_FACTORY = new CmgMessagesFactory();
    public static final ClusterStatePersistentSerializer INSTANCE = new ClusterStatePersistentSerializer();

    @Override
    protected void writeExternalData(ClusterState state, IgniteDataOutput out) throws IOException {
        ClusterStatePersistentSerializer.writeStringSet(state.cmgNodes(), out);
        ClusterStatePersistentSerializer.writeStringSet(state.metaStorageNodes(), out);
        out.writeUTF(state.version());
        out.writeUTF(state.clusterTag().clusterName());
        out.writeUuid(state.clusterTag().clusterId());
        ClusterStatePersistentSerializer.writeNullableString(state.initialClusterConfiguration(), out);
        List<UUID> formerClusterIds = state.formerClusterIds();
        out.writeVarInt(formerClusterIds == null ? -1L : (long)formerClusterIds.size());
        if (formerClusterIds != null) {
            for (UUID clusterId : formerClusterIds) {
                out.writeUuid(clusterId);
            }
        }
    }

    @Override
    protected ClusterState readExternalData(byte protoVer, IgniteDataInput in) throws IOException {
        return CMG_MSGS_FACTORY.clusterState().cmgNodes(ClusterStatePersistentSerializer.readStringSet(in)).metaStorageNodes(ClusterStatePersistentSerializer.readStringSet(in)).version(in.readUTF()).clusterTag(ClusterTag.clusterTag(CMG_MSGS_FACTORY, in.readUTF(), in.readUuid())).initialClusterConfiguration(ClusterStatePersistentSerializer.readNullableString(in)).formerClusterIds(ClusterStatePersistentSerializer.readFormerClusterIds(in)).build();
    }

    @Nullable
    private static List<UUID> readFormerClusterIds(IgniteDataInput in) throws IOException {
        int length = in.readVarIntAsInt();
        if (length == -1) {
            return null;
        }
        ArrayList<UUID> result = new ArrayList<UUID>(length);
        for (int i = 0; i < length; ++i) {
            result.add(in.readUuid());
        }
        return result;
    }
}

