/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.thin.io;

import java.nio.ByteBuffer;

public class ClientMessageDecoder {
    private byte[] data;
    private int cnt = -4;
    private int msgSize;

    public byte[] apply(ByteBuffer buf) {
        boolean msgReady = this.read(buf);
        return msgReady ? this.data : null;
    }

    private boolean read(ByteBuffer buf) {
        int missing;
        if (this.cnt < 0) {
            while (this.cnt < 0 && buf.hasRemaining()) {
                this.msgSize |= (buf.get() & 0xFF) << 8 * (4 + this.cnt);
                ++this.cnt;
            }
            if (this.cnt < 0) {
                return false;
            }
            this.data = new byte[this.msgSize];
        }
        assert (this.data != null);
        assert (this.cnt >= 0);
        assert (this.msgSize > 0);
        int remaining = buf.remaining();
        if (remaining > 0 && (missing = this.msgSize - this.cnt) > 0) {
            int len = Math.min(missing, remaining);
            buf.get(this.data, this.cnt, len);
            this.cnt += len;
        }
        if (this.cnt == this.msgSize) {
            this.cnt = -4;
            this.msgSize = 0;
            return true;
        }
        return false;
    }
}

