/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.rpc.impl.core;

import java.util.ArrayList;
import java.util.concurrent.Executor;
import org.apache.ignite.raft.jraft.Node;
import org.apache.ignite.raft.jraft.RaftMessagesFactory;
import org.apache.ignite.raft.jraft.entity.PeerId;
import org.apache.ignite.raft.jraft.error.RaftError;
import org.apache.ignite.raft.jraft.rpc.CoalescedHeartbeatResponseBuilder;
import org.apache.ignite.raft.jraft.rpc.Message;
import org.apache.ignite.raft.jraft.rpc.RaftRpcFactory;
import org.apache.ignite.raft.jraft.rpc.RaftServerService;
import org.apache.ignite.raft.jraft.rpc.RpcRequestClosure;
import org.apache.ignite.raft.jraft.rpc.RpcRequestProcessor;
import org.apache.ignite.raft.jraft.rpc.RpcRequests;

public class HeartbeatRequestProcessor
extends RpcRequestProcessor<RpcRequests.CoalescedHeartbeatRequest> {
    public HeartbeatRequestProcessor(Executor executor, RaftMessagesFactory msgFactory) {
        super(executor, msgFactory);
    }

    @Override
    public Message processRequest(RpcRequests.CoalescedHeartbeatRequest request, RpcRequestClosure done) {
        CoalescedHeartbeatResponseBuilder builder = this.msgFactory().coalescedHeartbeatResponse();
        builder.messages(new ArrayList<Message>());
        for (RpcRequests.AppendEntriesRequest message : request.messages()) {
            Message msg;
            PeerId peerId = PeerId.parsePeer(message.peerId());
            if (peerId == null) {
                msg = RaftRpcFactory.DEFAULT.newResponse(this.msgFactory(), RaftError.EINVAL, "Fail to parse peerId: %s", message.peerId());
            } else {
                Node node = done.getRpcCtx().getNodeManager().get(message.groupId(), peerId);
                if (node == null) {
                    msg = RaftRpcFactory.DEFAULT.newResponse(this.msgFactory(), RaftError.ENOENT, "Peer id not found: %s, group: %s", message.peerId(), message.groupId());
                } else {
                    RaftServerService svc = (RaftServerService)((Object)node);
                    msg = svc.handleAppendEntriesRequest(message, null);
                }
            }
            builder.messages().add(msg);
        }
        return builder.build();
    }

    @Override
    public String interest() {
        return RpcRequests.CoalescedHeartbeatRequest.class.getName();
    }
}

