/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx.message;

import java.util.UUID;
import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;
import org.apache.ignite.internal.replicator.message.ReplicationGroupIdMessage;
import org.apache.ignite.internal.tx.message.TxMessagesFactory;
import org.apache.ignite.internal.tx.message.TxRecoveryMessage;
import org.apache.ignite.internal.tx.message.TxRecoveryMessageBuilder;

class TxRecoveryMessageDeserializer
implements MessageDeserializer<TxRecoveryMessage> {
    private final TxRecoveryMessageBuilder msg;

    TxRecoveryMessageDeserializer(TxMessagesFactory messageFactory) {
        this.msg = messageFactory.txRecoveryMessage();
    }

    public Class<TxRecoveryMessage> klass() {
        return TxRecoveryMessage.class;
    }

    public TxRecoveryMessage getMessage() {
        return this.msg.build();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                Comparable<Long> tmp = reader.readBoxedLong("enlistmentConsistencyToken");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.enlistmentConsistencyToken((Long)tmp);
                reader.incrementState();
            }
            case 1: {
                Comparable<Long> tmp = (ReplicationGroupIdMessage)reader.readMessage("groupId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.groupId((ReplicationGroupIdMessage)tmp);
                reader.incrementState();
            }
            case 2: {
                Comparable<Long> tmp = reader.readUuid("txId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.txId((UUID)tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(TxRecoveryMessage.class);
    }
}

