/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.lang.invoke.MethodHandle;
import java.nio.ByteBuffer;
import org.apache.ignite.internal.util.FeatureChecker;
import org.apache.ignite.internal.util.GridUnsafe;
import org.apache.ignite.internal.util.PointerWrapping;

class JavaNioPointerWrapping
implements PointerWrapping {
    private static final Object NULL_OBJ = null;
    private final MethodHandle newDirectBufMh;
    private final Object javaNioAccessObj;

    JavaNioPointerWrapping(MethodHandle newDirectBufMh, Object javaNioAccessObj) {
        this.newDirectBufMh = newDirectBufMh;
        this.javaNioAccessObj = javaNioAccessObj;
    }

    @Override
    public ByteBuffer wrapPointer(long ptr, int len) {
        try {
            ByteBuffer buf = this.newDirectBufMh.invokeExact(this.javaNioAccessObj, ptr, len, NULL_OBJ);
            assert (buf.isDirect()) : "ptr=" + ptr + ", len=" + len;
            buf.order(GridUnsafe.NATIVE_BYTE_ORDER);
            return buf;
        }
        catch (Throwable e) {
            throw new RuntimeException("JavaNioAccess#newDirectByteBuffer() method is unavailable." + FeatureChecker.JAVA_STARTUP_PARAMS_WARN, e);
        }
    }
}

