/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.raft.service;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.network.ClusterService;
import org.apache.ignite.internal.raft.Peer;
import org.apache.ignite.internal.raft.PeersAndLearners;
import org.apache.ignite.internal.raft.service.LeaderWithTerm;
import org.apache.ignite.internal.raft.service.RaftCommandRunner;
import org.apache.ignite.internal.replicator.ReplicationGroupId;
import org.jetbrains.annotations.Nullable;

public interface RaftGroupService
extends RaftCommandRunner {
    public ReplicationGroupId groupId();

    @Nullable
    public Peer leader();

    @Nullable
    public List<Peer> peers();

    @Nullable
    public List<Peer> learners();

    public CompletableFuture<Void> refreshLeader();

    public CompletableFuture<LeaderWithTerm> refreshAndGetLeaderWithTerm();

    public CompletableFuture<Void> refreshMembers(boolean var1);

    public CompletableFuture<Void> addPeer(Peer var1);

    public CompletableFuture<Void> removePeer(Peer var1);

    public CompletableFuture<Void> changePeersAndLearners(PeersAndLearners var1, long var2);

    public CompletableFuture<Void> changePeersAndLearnersAsync(PeersAndLearners var1, long var2);

    public CompletableFuture<Void> addLearners(Collection<Peer> var1);

    public CompletableFuture<Void> removeLearners(Collection<Peer> var1);

    public CompletableFuture<Void> resetLearners(Collection<Peer> var1);

    public CompletableFuture<Void> snapshot(Peer var1);

    public CompletableFuture<Void> transferLeadership(Peer var1);

    public void shutdown();

    public CompletableFuture<Long> readIndex();

    public ClusterService clusterService();

    public void updateConfiguration(PeersAndLearners var1);
}

