/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.descriptors;

import java.io.IOException;
import java.util.Objects;
import org.apache.ignite.internal.catalog.descriptors.CatalogColumnCollation;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectSerializer;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.util.io.IgniteDataInput;
import org.apache.ignite.internal.util.io.IgniteDataOutput;

public class CatalogIndexColumnDescriptor {
    public static final CatalogObjectSerializer<CatalogIndexColumnDescriptor> SERIALIZER = new IndexColumnDescriptorSerializer();
    private final String name;
    private final CatalogColumnCollation collation;

    public CatalogIndexColumnDescriptor(String name, CatalogColumnCollation collation) {
        this.name = name;
        this.collation = Objects.requireNonNull(collation, "collation");
    }

    public String name() {
        return this.name;
    }

    public CatalogColumnCollation collation() {
        return this.collation;
    }

    public String toString() {
        return S.toString((Object)this);
    }

    private static class IndexColumnDescriptorSerializer
    implements CatalogObjectSerializer<CatalogIndexColumnDescriptor> {
        private IndexColumnDescriptorSerializer() {
        }

        @Override
        public CatalogIndexColumnDescriptor readFrom(IgniteDataInput input) throws IOException {
            String name = input.readUTF();
            CatalogColumnCollation collation = CatalogColumnCollation.unpack(input.readByte());
            return new CatalogIndexColumnDescriptor(name, collation);
        }

        @Override
        public void writeTo(CatalogIndexColumnDescriptor descriptor, IgniteDataOutput output) throws IOException {
            output.writeUTF(descriptor.name());
            output.writeByte((int)CatalogColumnCollation.pack(descriptor.collation()));
        }
    }
}

