/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed.disaster;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.descriptors.CatalogZoneDescriptor;
import org.apache.ignite.internal.distributionzones.NodeWithAttributes;
import org.apache.ignite.internal.distributionzones.rebalance.AssignmentUtil;
import org.apache.ignite.internal.distributionzones.rebalance.RebalanceUtil;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.lang.ByteArray;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.metastorage.MetaStorageManager;
import org.apache.ignite.internal.metastorage.dsl.Condition;
import org.apache.ignite.internal.metastorage.dsl.Conditions;
import org.apache.ignite.internal.metastorage.dsl.Iif;
import org.apache.ignite.internal.metastorage.dsl.Operation;
import org.apache.ignite.internal.metastorage.dsl.Operations;
import org.apache.ignite.internal.metastorage.dsl.Statements;
import org.apache.ignite.internal.metastorage.dsl.Update;
import org.apache.ignite.internal.partition.replicator.network.disaster.LocalPartitionStateEnum;
import org.apache.ignite.internal.partition.replicator.network.disaster.LocalPartitionStateMessage;
import org.apache.ignite.internal.partitiondistribution.Assignment;
import org.apache.ignite.internal.partitiondistribution.Assignments;
import org.apache.ignite.internal.partitiondistribution.PartitionDistributionUtils;
import org.apache.ignite.internal.replicator.TablePartitionId;
import org.apache.ignite.internal.table.distributed.disaster.DisasterRecoveryManager;
import org.apache.ignite.internal.table.distributed.disaster.DisasterRecoveryRequest;
import org.apache.ignite.internal.table.distributed.disaster.DisasterRecoveryRequestType;
import org.apache.ignite.internal.table.distributed.disaster.LocalPartitionStateMessageByNode;
import org.apache.ignite.internal.table.distributed.disaster.exceptions.DisasterRecoveryException;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.util.ByteUtils;
import org.apache.ignite.internal.util.CollectionUtils;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.lang.ErrorGroups;
import org.jetbrains.annotations.Nullable;

class GroupUpdateRequest
implements DisasterRecoveryRequest {
    private static final IgniteLogger LOG = Loggers.forClass(GroupUpdateRequest.class);
    private final UUID operationId;
    private final int catalogVersion;
    private final int zoneId;
    private final Map<Integer, Set<Integer>> partitionIds;
    private final boolean manualUpdate;

    GroupUpdateRequest(UUID operationId, int catalogVersion, int zoneId, Map<Integer, Set<Integer>> partitionIds, boolean manualUpdate) {
        this.operationId = operationId;
        this.catalogVersion = catalogVersion;
        this.zoneId = zoneId;
        this.partitionIds = Map.copyOf(partitionIds);
        this.manualUpdate = manualUpdate;
    }

    @Override
    public UUID operationId() {
        return this.operationId;
    }

    @Override
    public int zoneId() {
        return this.zoneId;
    }

    @Override
    public DisasterRecoveryRequestType type() {
        return DisasterRecoveryRequestType.SINGLE_NODE;
    }

    public int catalogVersion() {
        return this.catalogVersion;
    }

    public Map<Integer, Set<Integer>> partitionIds() {
        return this.partitionIds;
    }

    public boolean manualUpdate() {
        return this.manualUpdate;
    }

    @Override
    public CompletableFuture<Void> handle(DisasterRecoveryManager disasterRecoveryManager, long msRevision, HybridTimestamp msTimestamp) {
        int catalogVersion = disasterRecoveryManager.catalogManager.activeCatalogVersion(msTimestamp.longValue());
        if (this.catalogVersion != catalogVersion) {
            return CompletableFuture.failedFuture((Throwable)((Object)new DisasterRecoveryException(ErrorGroups.DisasterRecovery.CLUSTER_NOT_IDLE_ERR, "Cluster is not idle, concurrent DDL update detected.")));
        }
        Catalog catalog = disasterRecoveryManager.catalogManager.catalog(catalogVersion);
        CatalogZoneDescriptor zoneDescriptor = catalog.zone(this.zoneId);
        HashSet<Integer> allZonePartitionsToReset = new HashSet<Integer>();
        this.partitionIds.values().forEach(allZonePartitionsToReset::addAll);
        CompletableFuture<Map<TablePartitionId, LocalPartitionStateMessageByNode>> localStates = disasterRecoveryManager.localPartitionStatesInternal(Set.of(zoneDescriptor.name()), Collections.emptySet(), allZonePartitionsToReset, catalog);
        CompletableFuture dataNodesFuture = disasterRecoveryManager.dzManager.dataNodes(msRevision, catalogVersion, this.zoneId);
        return ((CompletableFuture)((CompletableFuture)dataNodesFuture.thenCombine(localStates, (dataNodes, localStatesMap) -> {
            Set<String> nodeConsistentIds = disasterRecoveryManager.dzManager.logicalTopology(msRevision).stream().map(NodeWithAttributes::nodeName).collect(Collectors.toSet());
            ArrayList<CompletableFuture<Void>> tableFuts = new ArrayList<CompletableFuture<Void>>(this.partitionIds.size());
            for (Map.Entry<Integer, Set<Integer>> tablePartitionEntry : this.partitionIds.entrySet()) {
                int[] partitionIdsArray = AssignmentUtil.partitionIds(tablePartitionEntry.getValue(), (int)zoneDescriptor.partitions());
                tableFuts.add(GroupUpdateRequest.forceAssignmentsUpdate(tablePartitionEntry.getKey(), zoneDescriptor, dataNodes, nodeConsistentIds, msRevision, disasterRecoveryManager.metaStorageManager, localStatesMap, catalog.time(), partitionIdsArray, this.manualUpdate));
            }
            return CompletableFuture.allOf(tableFuts.toArray(new CompletableFuture[0]));
        })).thenCompose(Function.identity())).whenComplete((unused, throwable) -> {
            if (throwable != null) {
                LOG.error("Failed to reset partition", throwable);
            }
        });
    }

    private static CompletableFuture<Void> forceAssignmentsUpdate(int tableId, CatalogZoneDescriptor zoneDescriptor, Set<String> dataNodes, Set<String> aliveNodesConsistentIds, long revision, MetaStorageManager metaStorageManager, Map<TablePartitionId, LocalPartitionStateMessageByNode> localStatesMap, long assignmentsTimestamp, int[] partitionIds, boolean manualUpdate) {
        return RebalanceUtil.tableStableAssignments((MetaStorageManager)metaStorageManager, (int)tableId, (int[])partitionIds).thenCompose(tableAssignments -> {
            if (tableAssignments.isEmpty()) {
                return CompletableFutures.nullCompletedFuture();
            }
            return GroupUpdateRequest.updateAssignments(tableId, zoneDescriptor, dataNodes, aliveNodesConsistentIds, revision, metaStorageManager, localStatesMap, assignmentsTimestamp, partitionIds, tableAssignments, manualUpdate);
        });
    }

    private static CompletableFuture<Void> updateAssignments(int tableId, CatalogZoneDescriptor zoneDescriptor, Set<String> dataNodes, Set<String> aliveNodesConsistentIds, long revision, MetaStorageManager metaStorageManager, Map<TablePartitionId, LocalPartitionStateMessageByNode> localStatesMap, long assignmentsTimestamp, int[] partitionIds, Map<Integer, Assignments> tableAssignments, boolean manualUpdate) {
        Set aliveDataNodes = CollectionUtils.intersect(dataNodes, aliveNodesConsistentIds);
        CompletableFuture[] futures = new CompletableFuture[partitionIds.length];
        for (int i = 0; i < partitionIds.length; ++i) {
            TablePartitionId replicaGrpId = new TablePartitionId(tableId, partitionIds[i]);
            futures[i] = GroupUpdateRequest.partitionUpdate(replicaGrpId, aliveDataNodes, aliveNodesConsistentIds, zoneDescriptor.partitions(), zoneDescriptor.replicas(), revision, metaStorageManager, tableAssignments.get(replicaGrpId.partitionId()).nodes(), localStatesMap.get(replicaGrpId), assignmentsTimestamp, manualUpdate).thenAccept(res -> DisasterRecoveryManager.LOG.info("Partition {} returned {} status on reset attempt", new Object[]{replicaGrpId, RebalanceUtil.UpdateStatus.valueOf((int)res)}));
        }
        return CompletableFuture.allOf(futures);
    }

    private static CompletableFuture<Integer> partitionUpdate(TablePartitionId partId, Collection<String> aliveDataNodes, Set<String> aliveNodesConsistentIds, int partitions, int replicas, long revision, MetaStorageManager metaStorageMgr, Set<Assignment> currentAssignments, LocalPartitionStateMessageByNode localPartitionStateMessageByNode, long assignmentsTimestamp, boolean manualUpdate) {
        boolean isProposedPendingEqualsProposedPlanned;
        Set<Assignment> partAssignments = GroupUpdateRequest.getAliveNodesWithData(aliveNodesConsistentIds, localPartitionStateMessageByNode);
        Set aliveStableNodes = CollectionUtils.intersect(currentAssignments, partAssignments);
        if (aliveStableNodes.size() >= replicas / 2 + 1) {
            return CompletableFuture.completedFuture(RebalanceUtil.UpdateStatus.ASSIGNMENT_NOT_UPDATED.ordinal());
        }
        if (aliveStableNodes.isEmpty() && !manualUpdate) {
            return CompletableFuture.completedFuture(RebalanceUtil.UpdateStatus.ASSIGNMENT_NOT_UPDATED.ordinal());
        }
        if (manualUpdate) {
            GroupUpdateRequest.enrichAssignments(partId, aliveDataNodes, partitions, replicas, partAssignments);
        }
        Assignment nextAssignment = GroupUpdateRequest.nextAssignment(localPartitionStateMessageByNode, partAssignments);
        boolean bl = isProposedPendingEqualsProposedPlanned = partAssignments.size() == 1;
        assert (partAssignments.contains(nextAssignment)) : IgniteStringFormatter.format((String)"Recovery nodes set doesn't contain the reset node assignment [partAssignments={}, nextAssignment={}]", (Object[])new Object[]{partAssignments, nextAssignment});
        Iif invokeClosure = GroupUpdateRequest.prepareMsInvokeClosure(partId, ByteUtils.longToBytesKeepingOrder((long)revision), Assignments.forced(Set.of(nextAssignment), (long)assignmentsTimestamp).toBytes(), isProposedPendingEqualsProposedPlanned ? null : Assignments.toBytes(partAssignments, (long)assignmentsTimestamp, (boolean)true));
        return metaStorageMgr.invoke(invokeClosure).thenApply(sr -> {
            switch (RebalanceUtil.UpdateStatus.valueOf((int)sr.getAsInt())) {
                case PENDING_KEY_UPDATED: {
                    LOG.info("Force update metastore pending partitions key [key={}, partition={}, table={}, newVal={}]", new Object[]{RebalanceUtil.pendingChangeTriggerKey((TablePartitionId)partId).toString(), partId.partitionId(), partId.tableId(), nextAssignment});
                    break;
                }
                case OUTDATED_UPDATE_RECEIVED: {
                    LOG.info("Received outdated force rebalance trigger event [revision={}, partition={}, table={}]", new Object[]{revision, partId.partitionId(), partId.tableId()});
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown return code for rebalance metastore multi-invoke");
                }
            }
            return sr.getAsInt();
        });
    }

    private static Assignment nextAssignment(LocalPartitionStateMessageByNode localPartitionStateByNode, Set<Assignment> assignments) {
        Optional<Assignment> nodeWithMaxLogIndex = assignments.stream().filter(assignment -> localPartitionStateByNode.partitionState(assignment.consistentId()) != null).min(Comparator.comparingLong(node -> localPartitionStateByNode.partitionState(node.consistentId()).logIndex()).reversed().thenComparing(Assignment::consistentId)).or(() -> assignments.stream().min(Comparator.comparing(Assignment::consistentId)));
        return nodeWithMaxLogIndex.orElseThrow();
    }

    static Iif prepareMsInvokeClosure(TablePartitionId partId, byte[] revisionBytes, byte[] pendingAssignmentsBytes, byte @Nullable [] plannedAssignmentsBytes) {
        ByteArray pendingChangeTriggerKey = RebalanceUtil.pendingChangeTriggerKey((TablePartitionId)partId);
        ByteArray partAssignmentsPendingKey = RebalanceUtil.pendingPartAssignmentsKey((TablePartitionId)partId);
        ByteArray partAssignmentsPlannedKey = RebalanceUtil.plannedPartAssignmentsKey((TablePartitionId)partId);
        return Statements.iif((Condition)Conditions.notExists((ByteArray)pendingChangeTriggerKey).or((Condition)Conditions.value((ByteArray)pendingChangeTriggerKey).lt(revisionBytes)), (Update)Operations.ops((Operation[])new Operation[]{Operations.put((ByteArray)pendingChangeTriggerKey, (byte[])revisionBytes), Operations.put((ByteArray)partAssignmentsPendingKey, (byte[])pendingAssignmentsBytes), plannedAssignmentsBytes == null ? Operations.remove((ByteArray)partAssignmentsPlannedKey) : Operations.put((ByteArray)partAssignmentsPlannedKey, (byte[])plannedAssignmentsBytes)}).yield(RebalanceUtil.UpdateStatus.PENDING_KEY_UPDATED.ordinal()), (Update)Operations.ops((Operation[])new Operation[0]).yield(RebalanceUtil.UpdateStatus.OUTDATED_UPDATE_RECEIVED.ordinal()));
    }

    private static Set<Assignment> getAliveNodesWithData(Set<String> aliveNodesConsistentIds, @Nullable LocalPartitionStateMessageByNode localPartitionStateMessageByNode) {
        if (localPartitionStateMessageByNode == null) {
            return Set.of();
        }
        HashSet<Assignment> partAssignments = new HashSet<Assignment>();
        for (Map.Entry<String, LocalPartitionStateMessage> entry : localPartitionStateMessageByNode.entrySet()) {
            String nodeName = entry.getKey();
            LocalPartitionStateEnum state = entry.getValue().state();
            if (!aliveNodesConsistentIds.contains(nodeName) || state != LocalPartitionStateEnum.HEALTHY && state != LocalPartitionStateEnum.CATCHING_UP) continue;
            partAssignments.add(Assignment.forPeer((String)nodeName));
        }
        return partAssignments;
    }

    private static void enrichAssignments(TablePartitionId partId, Collection<String> aliveDataNodes, int partitions, int replicas, Set<Assignment> partAssignments) {
        Set calcAssignments = PartitionDistributionUtils.calculateAssignmentForPartition(aliveDataNodes, (int)partId.partitionId(), (int)partitions, (int)replicas);
        for (Assignment calcAssignment : calcAssignments) {
            if (partAssignments.size() == replicas) break;
            partAssignments.add(calcAssignment);
        }
    }

    public String toString() {
        return S.toString((Object)this);
    }
}

