/*
 * Decompiled with CFR 0.152.
 */
package flex.tools.debugger.cli;

import flash.tools.debugger.PlayerDebugException;
import flash.tools.debugger.Session;
import flash.tools.debugger.Value;
import flash.tools.debugger.Variable;
import flash.tools.debugger.concrete.DValue;
import flash.tools.debugger.events.ExceptionFault;
import flash.tools.debugger.events.FaultEvent;
import flash.tools.debugger.expression.Context;
import flash.tools.debugger.expression.ExpressionEvaluatorException;
import flash.tools.debugger.expression.NoSuchVariableException;
import flash.tools.debugger.expression.PlayerFaultException;
import flex.tools.debugger.cli.ExpressionCache;
import flex.tools.debugger.cli.InternalProperty;
import flex.tools.debugger.cli.VariableFacade;
import java.util.StringTokenizer;
import java.util.Vector;

public class ExpressionContext
implements Context {
    ExpressionCache m_cache;
    Object m_current;
    boolean m_createIfMissing;
    Vector<String> m_namedPath;
    boolean m_nameLocked;
    String m_newline = System.getProperty("line.separator");
    int m_isolateId;

    public ExpressionContext(ExpressionCache expressionCache) {
        this.m_cache = expressionCache;
        this.m_current = null;
        this.m_createIfMissing = false;
        this.m_namedPath = new Vector();
        this.m_nameLocked = false;
        this.m_isolateId = 1;
    }

    public void setIsolateId(int n) {
        this.m_isolateId = n;
    }

    void setContext(Object object) {
        this.m_current = object;
    }

    void pushName(String string) {
        if (this.m_nameLocked || string.length() < 1) {
            return;
        }
        this.m_namedPath.add(string);
    }

    boolean setName(String string) {
        if (this.m_nameLocked) {
            return true;
        }
        this.m_namedPath.clear();
        this.pushName(string);
        return true;
    }

    void lockName() {
        this.m_nameLocked = true;
    }

    public String getName() {
        int n = this.m_namedPath.size();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            String string = this.m_namedPath.get(i);
            if (i > 0) {
                stringBuilder.append('.');
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    String getCurrentPackageName() {
        String string = null;
        try {
            Integer n = (Integer)this.m_cache.get("$listmodule");
            string = this.m_cache.getPackageName(n);
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return string;
    }

    @Override
    public void createPseudoVariables(boolean bl) {
        this.m_createIfMissing = bl;
    }

    @Override
    public Context createContext(Object object) {
        ExpressionContext expressionContext = new ExpressionContext(this.m_cache);
        expressionContext.setContext(object);
        expressionContext.createPseudoVariables(this.m_createIfMissing);
        expressionContext.m_namedPath.addAll(this.m_namedPath);
        expressionContext.setIsolateId(this.m_isolateId);
        return expressionContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void assign(Object object, Value value) throws NoSuchVariableException, PlayerFaultException {
        block8: {
            try {
                InternalProperty internalProperty = this.resolveToInternalProperty(object);
                if (internalProperty != null) {
                    this.assignInternal(internalProperty, value);
                    break block8;
                }
                boolean bl = this.m_createIfMissing;
                this.createPseudoVariables(true);
                Variable variable = null;
                try {
                    variable = this.resolveToVariable(object);
                }
                finally {
                    this.createPseudoVariables(bl);
                }
                if (variable == null) {
                    throw new NoSuchVariableException(this.m_current);
                }
                FaultEvent faultEvent = variable.setValue(this.getSession(), value.getType(), value.getValueAsString());
                if (faultEvent != null) {
                    throw new PlayerFaultException(faultEvent);
                }
            }
            catch (PlayerDebugException playerDebugException) {
                throw new ExpressionEvaluatorException(playerDebugException);
            }
        }
    }

    @Override
    public Object lookup(Object object) throws NoSuchVariableException, PlayerFaultException {
        Object object2 = null;
        try {
            object2 = this.resolveToInternalProperty(object);
            if (object2 == null && (object2 = this.resolveToVariable(object)) == null && (object2 = this.resolveToValue(object)) == null) {
                throw new NoSuchVariableException(object);
            }
            if (object2 instanceof VariableFacade) {
                ((VariableFacade)object2).setPath(this.getName());
            }
            Value value = null;
            if (object2 instanceof Variable) {
                value = object2 instanceof VariableFacade && ((VariableFacade)object2).getVariable() == null ? null : ((Variable)object2).getValue();
            } else if (object2 instanceof Value) {
                value = (Value)object2;
            }
            if (value != null && value.isAttributeSet(262144)) {
                String string = value.getValueAsString();
                throw new PlayerFaultException(new ExceptionFault(string, false, value, value.getIsolateId()));
            }
        }
        catch (PlayerDebugException playerDebugException) {
            object2 = Value.UNDEFINED;
        }
        return object2;
    }

    @Override
    public Object lookupMembers(Object object) throws NoSuchVariableException {
        String[] stringArray;
        Variable variable = null;
        Value value = null;
        Variable[] variableArray = null;
        try {
            variable = this.resolveToVariable(object);
            value = variable != null ? variable.getValue() : this.resolveToValue(object);
            variableArray = value.getMembers(this.getSession());
        }
        catch (NullPointerException nullPointerException) {
            throw new NoSuchVariableException(object);
        }
        catch (PlayerDebugException playerDebugException) {
            throw new NoSuchVariableException(object);
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (variable != null) {
            this.m_cache.appendVariable(stringBuilder, variable, this.m_isolateId);
        } else {
            this.m_cache.appendVariableValue(stringBuilder, value, this.m_isolateId);
        }
        boolean bl = this.m_cache.propertyEnabled("$displayattributes");
        if (bl && variable != null) {
            ExpressionCache.appendVariableAttributes(stringBuilder, variable);
        }
        if ((stringArray = value.getClassHierarchy(false)) != null && this.getSession().getPreference("$hiervars") != 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                stringBuilder.append(this.m_newline + "(Members of " + string + ")");
                for (int j = 0; j < variableArray.length; ++j) {
                    if (!string.equals(variableArray[j].getDefiningClass())) continue;
                    stringBuilder.append(this.m_newline + " ");
                    this.m_cache.appendVariable(stringBuilder, variableArray[j], this.m_isolateId);
                    if (!bl) continue;
                    ExpressionCache.appendVariableAttributes(stringBuilder, variableArray[j]);
                }
            }
        } else {
            for (int i = 0; i < variableArray.length; ++i) {
                stringBuilder.append(this.m_newline + " ");
                this.m_cache.appendVariable(stringBuilder, variableArray[i], this.m_isolateId);
                if (!bl) continue;
                ExpressionCache.appendVariableAttributes(stringBuilder, variableArray[i]);
            }
        }
        return stringBuilder.toString();
    }

    private void assignInternal(InternalProperty internalProperty, Value value) throws NoSuchVariableException, NumberFormatException, PlayerDebugException {
        if (value.getType() != 0) {
            throw new NumberFormatException(value.getValueAsString());
        }
        long l = Long.parseLong(value.getValueAsString());
        this.m_cache.put(internalProperty.getName(), (int)l);
    }

    InternalProperty resolveToInternalProperty(Object object) {
        if (object instanceof String && ((String)object).charAt(0) == '$') {
            String string = (String)object;
            Object object2 = null;
            try {
                object2 = this.m_cache.get(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return new InternalProperty(string, object2);
        }
        return null;
    }

    Variable resolveToVariable(Object object) throws PlayerDebugException {
        Variable variable = null;
        if (object instanceof Variable) {
            return (Variable)object;
        }
        String string = object.toString();
        long l = this.nameAsId(string);
        if (l == -1L) {
            l = this.determineContext(string);
            variable = this.locateForNamed(l, string, true);
            if (variable != null) {
                variable = new VariableFacade(variable, l, this.m_isolateId);
            } else if (this.m_createIfMissing && string.charAt(0) != '$') {
                variable = new VariableFacade(l, string, this.m_isolateId);
            }
        }
        return variable;
    }

    Value resolveToValue(Object object) throws PlayerDebugException {
        Value value = null;
        if (object instanceof Value) {
            return (Value)object;
        }
        if (object instanceof Variable) {
            return ((Variable)object).getValue();
        }
        if (object instanceof InternalProperty) {
            return DValue.forPrimitive(((InternalProperty)object).m_value, this.m_isolateId);
        }
        if (this.m_current == null) {
            String string = object.toString();
            long l = this.nameAsId(string);
            value = l != -1L ? this.getSession().getWorkerSession(this.m_isolateId).getValue((int)l) : (string.equals("undefined") ? DValue.forPrimitive(Value.UNDEFINED, this.m_isolateId) : this.getSession().getWorkerSession(this.m_isolateId).getGlobal(string));
        }
        return value;
    }

    long nameAsId(String string) {
        long l = -1L;
        try {
            if (string.charAt(0) == '#') {
                l = Long.parseLong(string.substring(1));
            }
        }
        catch (Exception exception) {
            l = -1L;
        }
        return l;
    }

    Variable memberNamed(long l, String string) throws NoSuchVariableException, PlayerDebugException {
        Variable variable = null;
        Value value = this.getSession().getWorkerSession(this.m_isolateId).getValue(l);
        if (value == null) {
            throw new NoSuchVariableException(string);
        }
        variable = value.getMemberNamed(this.getSession(), string);
        return variable;
    }

    long determineContext(String string) throws PlayerDebugException {
        long l = -1L;
        if (this.m_current != null) {
            l = this.toValue().getId();
        } else if (string != null) {
            long l2 = -100L;
            int n = (Integer)this.m_cache.get("$displayframenumber");
            Variable variable = null;
            Value value = null;
            Value value2 = null;
            value2 = this.locateParentForNamed(l2 -= (long)n, string, false);
            if (value2 != null || (variable = this.locateForNamed(l2, "this", false)) != null && this.setName("this") && (value2 = this.locateParentForNamed(variable.getValue().getId(), string, true)) != null || this.setName("_root") && (value2 = this.locateParentForNamed(-4L, string, true)) != null || this.setName("_global") && (value2 = this.locateParentForNamed(-2L, string, true)) != null || (value = this.locate(-2L, this.getCurrentPackageName(), false)) == null || !this.setName("_global." + this.getCurrentPackageName()) || (value2 = this.locateParentForNamed(value.getId(), string, true)) != null) {
                // empty if block
            }
            if (value2 != null) {
                l = value2.getId();
                this.pushName(string);
                this.lockName();
            }
        }
        return l;
    }

    Value locateParentForNamed(long l, String string, boolean bl) throws PlayerDebugException {
        StringBuilder stringBuilder = new StringBuilder();
        Variable variable = null;
        Value value = null;
        try {
            variable = this.memberNamed(l, string);
            while (variable == null && bl) {
                Variable variable2 = this.memberNamed(l, "__proto__");
                stringBuilder.append("__proto__");
                if (variable2 == null) {
                    bl = false;
                    continue;
                }
                l = variable2.getValue().getId();
                variable = this.memberNamed(l, string);
                if (variable != null) continue;
                stringBuilder.append('.');
            }
        }
        catch (NoSuchVariableException noSuchVariableException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (variable != null) {
            this.pushName(stringBuilder.toString());
            value = this.getSession().getWorkerSession(this.m_isolateId).getValue(l);
        }
        return value;
    }

    Variable locateForNamed(long l, String string, boolean bl) throws PlayerDebugException {
        Variable variable = null;
        Value value = this.locateParentForNamed(l, string, bl);
        if (value != null) {
            try {
                variable = this.memberNamed(value.getId(), string);
            }
            catch (NoSuchVariableException noSuchVariableException) {
                value = null;
            }
        }
        return variable;
    }

    Value locate(long l, String string, boolean bl) throws PlayerDebugException {
        if (string == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        Value value = this.getSession().getWorkerSession(this.m_isolateId).getValue(l);
        while (stringTokenizer.hasMoreTokens() && value != null) {
            value = this.locateForNamed(value.getId(), stringTokenizer.nextToken(), bl).getValue();
        }
        return value;
    }

    @Override
    public Value toValue(Object object) {
        if (object instanceof Value) {
            return (Value)object;
        }
        if (object instanceof Variable) {
            return ((Variable)object).getValue();
        }
        if (object instanceof InternalProperty) {
            return DValue.forPrimitive(((InternalProperty)object).m_value, this.m_isolateId);
        }
        return DValue.forPrimitive(object, this.m_isolateId);
    }

    @Override
    public Value toValue() {
        return this.toValue(this.m_current);
    }

    @Override
    public Session getSession() {
        return this.m_cache.getSession();
    }

    @Override
    public int getIsolateId() {
        return this.m_isolateId;
    }
}

