/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.http;

import java.net.InetAddress;
import java.util.Vector;
import org.cybergarage.http.HTTPRequestListener;
import org.cybergarage.http.HTTPServer;
import org.cybergarage.net.HostInterface;

public class HTTPServerList
extends Vector {
    private InetAddress[] binds = null;
    private int port = 4004;

    public HTTPServerList() {
    }

    public HTTPServerList(InetAddress[] list, int port) {
        this.binds = list;
        this.port = port;
    }

    public void addRequestListener(HTTPRequestListener listener) {
        int nServers = this.size();
        for (int n = 0; n < nServers; ++n) {
            HTTPServer server = this.getHTTPServer(n);
            server.addRequestListener(listener);
        }
    }

    public HTTPServer getHTTPServer(int n) {
        return (HTTPServer)this.get(n);
    }

    public void close() {
        int nServers = this.size();
        for (int n = 0; n < nServers; ++n) {
            HTTPServer server = this.getHTTPServer(n);
            server.close();
        }
    }

    public int open() {
        String[] bindAddresses;
        InetAddress[] binds = this.binds;
        if (binds != null) {
            bindAddresses = new String[binds.length];
            for (int i = 0; i < binds.length; ++i) {
                bindAddresses[i] = binds[i].getHostAddress();
            }
        } else {
            int nHostAddrs = HostInterface.getNHostAddresses();
            bindAddresses = new String[nHostAddrs];
            for (int n = 0; n < nHostAddrs; ++n) {
                bindAddresses[n] = HostInterface.getHostAddress(n);
            }
        }
        int j = 0;
        for (int i = 0; i < bindAddresses.length; ++i) {
            HTTPServer httpServer = new HTTPServer();
            if (bindAddresses[i] == null || !httpServer.open(bindAddresses[i], this.port)) {
                this.close();
                this.clear();
                continue;
            }
            this.add(httpServer);
            ++j;
        }
        return j;
    }

    public boolean open(int port) {
        this.port = port;
        return this.open() != 0;
    }

    public void start() {
        int nServers = this.size();
        for (int n = 0; n < nServers; ++n) {
            HTTPServer server = this.getHTTPServer(n);
            server.start();
        }
    }

    public void stop() {
        int nServers = this.size();
        for (int n = 0; n < nServers; ++n) {
            HTTPServer server = this.getHTTPServer(n);
            server.stop();
        }
    }
}

