/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.manipulator.metadata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.felix.ipojo.manipulator.MetadataProvider;
import org.apache.felix.ipojo.manipulator.Reporter;
import org.apache.felix.ipojo.metadata.Element;

public class CompositeMetadataProvider
implements MetadataProvider {
    private List<MetadataProvider> m_providers = new ArrayList<MetadataProvider>();
    private Reporter m_reporter;

    public CompositeMetadataProvider(Reporter reporter) {
        this.m_reporter = reporter;
    }

    public void addMetadataProvider(MetadataProvider provider) {
        this.m_providers.add(provider);
    }

    @Override
    public List<Element> getMetadatas() throws IOException {
        ArrayList<Element> metadata = new ArrayList<Element>();
        for (MetadataProvider provider : this.m_providers) {
            List<Element> loaded = provider.getMetadatas();
            for (Element meta : loaded) {
                if (this.isInstance(meta)) {
                    metadata.add(meta);
                    continue;
                }
                String name = this.getComponentName(meta);
                if (name != null) {
                    if (this.isDuplicate(metadata, name)) {
                        this.m_reporter.warn("The component type " + name + " is duplicated.", new Object[0]);
                        continue;
                    }
                    metadata.add(meta);
                    continue;
                }
                metadata.add(meta);
            }
        }
        return metadata;
    }

    private boolean isDuplicate(List<Element> elements, String name) {
        for (Element element : elements) {
            if (this.isInstance(element) || !name.equals(this.getComponentName(element))) continue;
            return true;
        }
        return false;
    }

    private String getComponentName(Element element) {
        return element.getAttribute("name");
    }

    private boolean isInstance(Element element) {
        return "instance".equals(element.getName());
    }
}

