/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.samples.bridge;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletContext;
import org.apache.felix.framework.Felix;
import org.apache.felix.http.samples.bridge.ProvisionActivator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FrameworkService {
    private final ServletContext context;
    private Felix felix;

    public FrameworkService(ServletContext context) {
        this.context = context;
    }

    public void start() {
        try {
            this.doStart();
        }
        catch (Exception e) {
            this.log("Failed to start framework", (Throwable)e);
        }
    }

    public void stop() {
        try {
            this.doStop();
        }
        catch (Exception e) {
            this.log("Error stopping framework", (Throwable)e);
        }
    }

    private void doStart() throws Exception {
        Felix tmp = new Felix(this.createConfig());
        tmp.start();
        this.felix = tmp;
        this.log("OSGi framework started", null);
    }

    private void doStop() throws Exception {
        if (this.felix != null) {
            this.felix.stop();
        }
        this.log("OSGi framework stopped", null);
    }

    private Map<String, Object> createConfig() throws Exception {
        Properties props = new Properties();
        props.load(this.context.getResourceAsStream("/WEB-INF/framework.properties"));
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Object key : props.keySet()) {
            map.put(key.toString(), props.get(key));
        }
        map.put("felix.systembundle.activators", Arrays.asList(new ProvisionActivator(this.context)));
        return map;
    }

    private void log(String message, Throwable cause) {
        this.context.log(message, cause);
    }
}

