/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.deployment.rp.autoconf;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.felix.deployment.rp.autoconf.AutoConfResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistencyManager {
    private static final FileFilter FILES_ONLY_FILTER = new FileFilter(){

        public boolean accept(File pathname) {
            return pathname.isFile();
        }
    };
    private final File m_root;

    public PersistencyManager(File root) {
        this.m_root = root;
    }

    public void delete(String name) throws IOException {
        File target = new File(this.m_root, name = name.replace('/', File.separatorChar));
        if (target.exists() && !target.delete()) {
            throw new IOException("Unable to delete file: " + target.getAbsolutePath());
        }
        while (target.getParentFile().list().length == 0 && !target.getParentFile().getAbsolutePath().equals(this.m_root.getAbsolutePath())) {
            target = target.getParentFile();
            target.delete();
        }
    }

    public List<String> getResourceNames() {
        ArrayList<String> result = new ArrayList<String>();
        File[] list = this.m_root.listFiles(FILES_ONLY_FILTER);
        if (list != null && list.length > 0) {
            for (File resource : list) {
                result.add(resource.getName());
            }
        }
        return result;
    }

    public List<AutoConfResource> load(String name) throws IOException {
        List<AutoConfResource> resources = new ArrayList<AutoConfResource>();
        File resourcesFile = new File(this.m_root, name = name.replace('/', File.separatorChar));
        if (!resourcesFile.exists()) {
            return resources;
        }
        ObjectInputStream in = null;
        try {
            in = new ObjectInputStream(new FileInputStream(resourcesFile));
            resources = (List)in.readObject();
        }
        catch (FileNotFoundException e) {
            throw new IOException("Resource does not exist: " + name);
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Unable to recreate persisted object from file: " + name);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
        return resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(String name, List<AutoConfResource> configs) throws IOException {
        File targetDir = this.m_root;
        if ((name = name.replace('/', File.separatorChar)).startsWith(File.separator)) {
            name = name.substring(1);
        }
        int lastSeparator = name.lastIndexOf(File.separator);
        File target = null;
        if (lastSeparator != -1) {
            targetDir = new File(targetDir, name.substring(0, lastSeparator));
            targetDir.mkdirs();
        }
        target = new File(targetDir, name.substring(lastSeparator + 1));
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(new FileOutputStream(target));
            out.writeObject(configs);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

