/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db.exceptions;

import java.sql.SQLException;
import org.apache.empire.commons.ErrorType;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.db.DBObject;
import org.apache.empire.db.exceptions.EmpireSQLException;
import org.apache.empire.dbms.DBMSHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryFailedException
extends EmpireSQLException {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(QueryFailedException.class);
    public static final ErrorType errorType = new ErrorType("error.db.queryFailed", "Error executing query: {0} \nwith params [{2}]. \nNative error is: {1}");

    public QueryFailedException(DBMSHandler dbms, String sqlCmd, String sqlParams, SQLException cause) {
        super(errorType, new String[]{sqlCmd, QueryFailedException.messageFromSQLException(dbms, cause), StringUtils.coalesce(sqlParams, "")}, 1, cause);
    }

    public QueryFailedException(DBObject obj, String sqlCmd, String sqlParams, SQLException cause) {
        this(QueryFailedException.handlerFromObject(obj), sqlCmd, sqlParams, cause);
    }

    @Override
    protected void log() {
        if (log.isErrorEnabled()) {
            log.error(this.getMessage());
        } else {
            super.log();
        }
    }
}

