/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db;

import java.io.Closeable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.empire.commons.ClassUtils;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.data.Column;
import org.apache.empire.data.ColumnExpr;
import org.apache.empire.data.DataType;
import org.apache.empire.data.Entity;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBCommandExpr;
import org.apache.empire.db.DBContext;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBQueryColumn;
import org.apache.empire.db.DBRecordBase;
import org.apache.empire.db.DBRecordData;
import org.apache.empire.db.DBRowSet;
import org.apache.empire.db.DBUtils;
import org.apache.empire.db.DBXmlDictionary;
import org.apache.empire.db.exceptions.EmpireSQLException;
import org.apache.empire.db.exceptions.NoPrimaryKeyException;
import org.apache.empire.db.exceptions.QueryNoResultException;
import org.apache.empire.db.list.DataBean;
import org.apache.empire.dbms.DBMSHandler;
import org.apache.empire.exceptions.BeanInstantiationException;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.exceptions.InvalidOperationException;
import org.apache.empire.exceptions.ObjectNotValidException;
import org.apache.empire.xml.XMLUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DBReader
extends DBRecordData
implements Closeable {
    protected static final Logger log = LoggerFactory.getLogger(DBReader.class);
    private static boolean trackOpenResultSets = false;
    private static ThreadLocal<Map<DBReader, Exception>> threadLocalOpenResultSets = new ThreadLocal();
    protected final DBContext context;
    private DBDatabase db = null;
    private DBColumnExpr[] columns = null;
    private ResultSet rset = null;
    private DBMSHandler dbms = null;
    private Map<ColumnExpr, Integer> fieldIndexMap = null;
    private DBReaderIterator iterator = null;

    public DBReader(DBContext context, boolean useFieldIndexMap) {
        this.context = context;
        if (useFieldIndexMap) {
            this.fieldIndexMap = new HashMap<ColumnExpr, Integer>();
        }
    }

    public DBReader(DBContext context) {
        this(context, true);
    }

    @Override
    public DBContext getContext() {
        return this.context;
    }

    public final DBDatabase getDatabase() {
        return this.db;
    }

    public boolean getScrollable() {
        try {
            return this.rset != null && this.rset.getType() != 1003;
        }
        catch (SQLException e) {
            log.error("Cannot determine Resultset type", (Throwable)e);
            return false;
        }
    }

    @Override
    public int getFieldIndex(ColumnExpr column) {
        if (this.fieldIndexMap == null) {
            return this.findFieldIndex(column);
        }
        Integer index = this.fieldIndexMap.get(column);
        if (index == null) {
            index = this.findFieldIndex(column);
            this.fieldIndexMap.put(column, index);
        }
        return index;
    }

    @Override
    public DBColumnExpr getColumn(int iColumn) {
        if (this.columns == null || iColumn < 0 || iColumn >= this.columns.length) {
            return null;
        }
        return this.columns[iColumn];
    }

    @Override
    public int getFieldIndex(String column) {
        if (this.columns != null) {
            for (int i = 0; i < this.columns.length; ++i) {
                if (!this.columns[i].getName().equalsIgnoreCase(column)) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public boolean isNull(int index) {
        if (index < 0 || index >= this.columns.length) {
            log.warn("Index {} is out of range", (Object)index);
            throw new InvalidArgumentException("index", index);
        }
        try {
            this.rset.getObject(index + 1);
            return this.rset.wasNull();
        }
        catch (Exception e) {
            log.error("isNullValue exception", (Throwable)e);
            return super.isNull(index);
        }
    }

    @Override
    public Object getValue(int index) {
        if (index < 0 || index >= this.columns.length) {
            throw new InvalidArgumentException("index", index);
        }
        try {
            DataType dataType = this.columns[index].getDataType();
            return this.dbms.getResultValue(this.rset, index + 1, dataType);
        }
        catch (SQLException e) {
            throw new EmpireSQLException(this.context.getDbms(), e);
        }
    }

    public Object[] getRecordKey(Entity entity) {
        Column[] keyColumns = entity.getKeyColumns();
        if (keyColumns == null || keyColumns.length == 0) {
            throw new NoPrimaryKeyException(entity);
        }
        Object[] key = new Object[keyColumns.length];
        for (int i = 0; i < key.length; ++i) {
            key[i] = this.get(keyColumns[i]);
        }
        return key;
    }

    public long getRecordId(Entity entity) {
        Column[] keyColumns = entity.getKeyColumns();
        if (keyColumns == null || keyColumns.length != 1) {
            throw new InvalidArgumentException("entity", entity.getEntityName());
        }
        return this.getLong(keyColumns[0]);
    }

    public boolean isOpen() {
        return this.rset != null;
    }

    public void open(DBCommandExpr cmd, boolean scrollable) {
        if (this.isOpen()) {
            this.close();
        }
        String sqlCmd = cmd.getSelect();
        Object[] paramValues = cmd.getParamValues();
        DBUtils utils = this.context.getUtils();
        ResultSet queryRset = utils.executeQuery(sqlCmd, paramValues, scrollable);
        if (queryRset == null) {
            throw new QueryNoResultException(sqlCmd);
        }
        this.init((DBDatabase)cmd.getDatabase(), cmd.getSelectExprList(), queryRset);
    }

    public final void open(DBCommandExpr cmd) {
        this.open(cmd, false);
    }

    public void getRecordData(DBCommandExpr cmd) {
        this.open(cmd);
        if (!this.moveNext()) {
            throw new QueryNoResultException(cmd.getSelect());
        }
    }

    @Override
    public void close() {
        try {
            if (this.iterator != null) {
                this.iterator.dispose();
                this.iterator = null;
            }
            if (this.rset != null) {
                this.context.getDbms().closeResultSet(this.rset);
                this.endTrackingThisResultSet();
            }
            this.columns = null;
            this.rset = null;
            this.dbms = null;
            if (this.fieldIndexMap != null) {
                this.fieldIndexMap.clear();
            }
        }
        catch (Exception e) {
            log.warn(e.toString());
        }
    }

    public boolean skipRows(int count) {
        try {
            if (this.rset == null) {
                throw new ObjectNotValidException(this);
            }
            int type = this.rset.getType();
            if (type == 1003) {
                if (count < 0) {
                    throw new InvalidArgumentException("count", count);
                }
                while (count > 0) {
                    if (!this.moveNext()) {
                        return false;
                    }
                    --count;
                }
                return true;
            }
            if (count > 0) {
                if (!this.rset.next()) {
                    return false;
                }
                if (count > 1) {
                    return this.rset.relative(count - 1);
                }
            } else if (count < 0) {
                if (!this.rset.previous()) {
                    return false;
                }
                if (count < -1) {
                    return this.rset.relative(count + 1);
                }
            }
            return true;
        }
        catch (SQLException e) {
            throw new EmpireSQLException(this.context.getDbms(), e);
        }
    }

    public boolean moveNext() {
        try {
            if (this.rset == null) {
                throw new ObjectNotValidException(this);
            }
            if (!this.rset.next()) {
                this.close();
                return false;
            }
            return true;
        }
        catch (SQLException e) {
            throw new EmpireSQLException(this.context.getDbms(), e);
        }
    }

    public Iterator<DBRecordData> iterator(int maxCount) {
        if (this.iterator == null && this.rset != null) {
            this.iterator = this.getScrollable() ? new DBReaderScrollableIterator(maxCount) : new DBReaderForwardIterator(maxCount);
        }
        return this.iterator;
    }

    public final Iterator<DBRecordData> iterator() {
        return this.iterator(-1);
    }

    public void initRecord(DBRecordBase rec) {
        if (!this.isOpen()) {
            throw new ObjectNotValidException(this);
        }
        DBRowSet rowset = rec.getRowSet();
        rowset.initRecord(rec, this);
    }

    public <L extends List<T>, T> L getBeanList(L list, Class<T> t, Object parent, int maxCount) {
        if (!this.isOpen()) {
            throw new ObjectNotValidException(this);
        }
        try {
            Constructor<?> ctor = this.findBeanConstructor(t);
            Object[] args = ctor != null ? new Object[this.getFieldCount()] : null;
            Class<?>[] ctorParamTypes = ctor != null ? ctor.getParameterTypes() : null;
            int rownum = 0;
            while (this.moveNext() && maxCount != 0) {
                Object bean;
                if (ctor != null) {
                    for (int i = 0; i < this.getFieldCount(); ++i) {
                        args[i] = ObjectUtils.convert(ctorParamTypes[i], this.getValue(i));
                    }
                    bean = ctor.newInstance(args);
                } else {
                    bean = t.newInstance();
                    this.setBeanProperties(bean);
                }
                list.add(bean);
                ++rownum;
                if (bean instanceof DataBean) {
                    ((DataBean)bean).initialize(this.getDatabase(), this.context, rownum, parent);
                }
                if (maxCount <= 0) continue;
                --maxCount;
            }
            return list;
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new BeanInstantiationException(t, e);
        }
    }

    public final <T> List<T> getBeanList(Class<T> t, int maxItems) {
        return this.getBeanList(new ArrayList(), t, null, maxItems);
    }

    public final <T> List<T> getBeanList(Class<T> t) {
        return this.getBeanList(t, -1);
    }

    @Override
    public int addXmlMeta(Element parent) {
        if (this.columns == null) {
            throw new ObjectNotValidException(this);
        }
        for (int i = 0; i < this.columns.length; ++i) {
            this.columns[i].addXml(parent, 0L);
        }
        return this.columns.length;
    }

    @Override
    public int addXmlData(Element parent) {
        if (this.rset == null) {
            throw new ObjectNotValidException(this);
        }
        for (int i = 0; i < this.columns.length; ++i) {
            String name = this.columns[i].getName();
            String idColumnAttr = this.getXmlDictionary().getRowIdColumnAttribute();
            if (name.equalsIgnoreCase("id")) {
                parent.setAttribute(idColumnAttr, this.getString(i));
                continue;
            }
            String value = this.getString(i);
            Element elem = XMLUtil.addElement(parent, name, value);
            if (value != null) continue;
            elem.setAttribute("null", "yes");
        }
        return this.columns.length;
    }

    public int addRows(Element parent) {
        int count = 0;
        if (this.rset == null) {
            return 0;
        }
        String rowElementName = this.getXmlDictionary().getRowElementName();
        while (this.moveNext()) {
            this.addXmlData(XMLUtil.addElement(parent, rowElementName));
            ++count;
        }
        return count;
    }

    protected DBXmlDictionary getXmlDictionary() {
        return DBXmlDictionary.getInstance();
    }

    @Override
    public Document getXmlDocument() {
        if (this.rset == null) {
            return null;
        }
        String rowsetElementName = this.getXmlDictionary().getRowSetElementName();
        Element root = XMLUtil.createDocument(rowsetElementName);
        this.addXmlMeta(root);
        this.addRows(root);
        return root.getOwnerDocument();
    }

    @Override
    public int getFieldCount() {
        return this.columns != null ? this.columns.length : 0;
    }

    protected void init(DBDatabase db, DBColumnExpr[] columns, ResultSet rset) {
        this.db = db;
        this.dbms = db.getDbms();
        this.columns = columns;
        this.rset = rset;
        if (this.fieldIndexMap != null) {
            this.fieldIndexMap.clear();
        }
        this.trackThisResultSet();
    }

    protected final DBColumnExpr[] getColumnExprList() {
        return this.columns;
    }

    protected final ResultSet getResultSet() {
        return this.rset;
    }

    protected int findFieldIndex(ColumnExpr column) {
        if (this.columns == null) {
            throw new ObjectNotValidException(this);
        }
        int index = ObjectUtils.indexOf(this.columns, column);
        if (index >= 0) {
            return index;
        }
        if (column instanceof DBColumn) {
            for (int i = 0; i < this.columns.length; ++i) {
                DBColumn updColumn = this.columns[i].getUpdateColumn();
                if (updColumn != null && updColumn.equals(column)) {
                    return i;
                }
                if (!(updColumn instanceof DBQueryColumn) || (updColumn = ((DBQueryColumn)updColumn).getExpr().getUpdateColumn()) == null || !updColumn.equals(column)) continue;
                return i;
            }
        }
        return -1;
    }

    protected Constructor<?> findBeanConstructor(Class<?> beanClass) {
        Class[] paramTypes = new Class[this.getFieldCount()];
        for (int i = 0; i < this.columns.length; ++i) {
            paramTypes[i] = this.columns[i].getJavaType();
        }
        Constructor<?> ctor = ClassUtils.findMatchingConstructor(beanClass, -1, paramTypes);
        return ctor;
    }

    protected synchronized void trackThisResultSet() {
        Exception stackException;
        if (!trackOpenResultSets) {
            return;
        }
        Map<DBReader, Exception> openResultSets = threadLocalOpenResultSets.get();
        if (openResultSets == null) {
            openResultSets = new HashMap<DBReader, Exception>(2);
            threadLocalOpenResultSets.set(openResultSets);
        }
        if ((stackException = openResultSets.get(this)) != null) {
            log.error("DBRecordSet.addOpenResultSet called for an object which is already in the open list. This is the stack of the method opening the object which was not previously closed.", (Throwable)stackException);
        }
        openResultSets.put(this, new Exception());
    }

    protected synchronized void endTrackingThisResultSet() {
        if (!trackOpenResultSets) {
            return;
        }
        Map<DBReader, Exception> openResultSets = threadLocalOpenResultSets.get();
        if (!openResultSets.containsKey(this)) {
            log.error("DBRecordSet.removeOpenResultSet called for an object which is not in the open list. Here is the current stack.", (Throwable)new Exception());
        } else {
            openResultSets.remove(this);
        }
    }

    public static synchronized boolean enableOpenResultSetTracking(boolean enable) {
        boolean prev = trackOpenResultSets;
        trackOpenResultSets = enable;
        return prev;
    }

    public static synchronized void checkOpenResultSets() {
        if (!trackOpenResultSets) {
            throw new InvalidOperationException("Open-ResultSet-Tracking has not been enabled. Use DBReader.enableOpenResultSetTracking() to enable or disable.");
        }
        Map<DBReader, Exception> openResultSets = threadLocalOpenResultSets.get();
        if (openResultSets != null && !openResultSets.isEmpty()) {
            Object[] keySet = openResultSets.keySet().toArray();
            for (int i = 0; i < keySet.length; ++i) {
                Exception stackException = openResultSets.get(keySet[i]);
                log.error("A DBReader was not closed. Stack of opening code is ", (Throwable)stackException);
            }
            openResultSets.clear();
        }
    }

    public class DBReaderForwardIterator
    extends DBReaderIterator {
        private boolean getCurrent;
        private boolean hasCurrent;

        public DBReaderForwardIterator(int maxCount) {
            super(maxCount);
            this.getCurrent = true;
            this.hasCurrent = false;
        }

        @Override
        public boolean hasNext() {
            if (this.curCount >= this.maxCount) {
                return false;
            }
            if (DBReader.this.rset == null) {
                throw new ObjectNotValidException(this);
            }
            if (this.getCurrent) {
                this.getCurrent = false;
                this.hasCurrent = DBReader.this.moveNext();
            }
            return this.hasCurrent;
        }

        @Override
        public DBRecordData next() {
            if (!this.hasCurrent) {
                return null;
            }
            if (this.getCurrent && !DBReader.this.moveNext()) {
                this.hasCurrent = false;
                this.getCurrent = false;
                return null;
            }
            ++this.curCount;
            this.getCurrent = true;
            return DBReader.this;
        }
    }

    public class DBReaderScrollableIterator
    extends DBReaderIterator {
        public DBReaderScrollableIterator(int maxCount) {
            super(maxCount);
        }

        @Override
        public boolean hasNext() {
            try {
                if (this.curCount >= this.maxCount) {
                    return false;
                }
                return DBReader.this.rset != null && !DBReader.this.rset.isLast() && !DBReader.this.rset.isAfterLast();
            }
            catch (SQLException e) {
                throw new EmpireSQLException(DBReader.this.context.getDbms(), e);
            }
        }

        @Override
        public DBRecordData next() {
            if (this.curCount < this.maxCount && DBReader.this.moveNext()) {
                ++this.curCount;
                return DBReader.this;
            }
            return null;
        }
    }

    public abstract class DBReaderIterator
    implements Iterator<DBRecordData> {
        protected int curCount = 0;
        protected int maxCount = 0;

        public DBReaderIterator(int maxCount) {
            if (maxCount < 0) {
                maxCount = Integer.MAX_VALUE;
            }
            this.maxCount = maxCount;
        }

        @Override
        public void remove() {
            log.error("DBReader.remove ist not implemented!");
        }

        public void dispose() {
            this.maxCount = -1;
            this.curCount = -1;
        }
    }
}

