/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.data.Column;
import org.apache.empire.data.DataType;
import org.apache.empire.data.Record;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBExpr;
import org.apache.empire.db.DBRowSet;
import org.apache.empire.db.DBSQLBuilder;
import org.apache.empire.db.DBTable;
import org.apache.empire.db.DBTableColumn;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.exceptions.ItemNotFoundException;
import org.apache.empire.exceptions.NotSupportedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DBGeneratedValue
extends DBExpr {
    protected static final Logger log = LoggerFactory.getLogger(DBGeneratedValue.class);
    protected final DBDatabase db;

    public static DBGeneratedValue byTrigger(DBTable table, String triggerName, DBTableColumn ... columns) {
        return new DBTriggerGeneratedValue(table, triggerName, columns);
    }

    public static DBGeneratedValue byFunction(DBTable table, String functionTemplate) {
        return new DBFuncGeneratedValue(table, functionTemplate);
    }

    public DBGeneratedValue(DBDatabase db) {
        this.db = db;
    }

    public abstract boolean isModified(Record var1);

    public abstract Object eval(Record var1);

    @Override
    public <T extends DBDatabase> T getDatabase() {
        return (T)this.db;
    }

    public static class DBFuncGeneratedValue
    extends DBGeneratedValue {
        private final List<Object> parts = new ArrayList<Object>();

        public DBFuncGeneratedValue(DBTable table, String template) {
            super(table.getDatabase());
            int idx = 0;
            while (idx < template.length()) {
                int nxt = template.indexOf(91, idx);
                if (nxt < 0) {
                    this.parts.add(template.substring(idx));
                    break;
                }
                this.parts.add(template.substring(idx, nxt++));
                int end = template.indexOf(93, nxt);
                if (end < 0) {
                    throw new InvalidArgumentException("template", template);
                }
                String name = template.substring(nxt, end);
                DBColumn column = table.getColumn(name);
                if (column == null) {
                    throw new ItemNotFoundException((Object)name);
                }
                this.parts.add(column);
                idx = end + 1;
            }
        }

        @Override
        public boolean isModified(Record record) {
            for (Object part : this.parts) {
                if (!(part instanceof Column) || !record.wasModified((Column)part)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Object eval(Record record) {
            for (Object part : this.parts) {
                if (!(part instanceof Column) || !record.isNull((Column)part)) continue;
                return null;
            }
            DBSQLBuilder sql = this.db.getDbms().createSQLBuilder();
            for (Object part : this.parts) {
                if (part instanceof Column) {
                    Column col = (Column)part;
                    Object value = record.get(col);
                    sql.appendValue(col.getDataType(), value);
                    continue;
                }
                sql.append(part.toString());
            }
            return this.db.getValueExpr(sql.toString(), DataType.UNKNOWN);
        }

        @Override
        public void addReferencedColumns(Set<DBColumn> list) {
            for (Object part : this.parts) {
                if (!(part instanceof DBColumn)) continue;
                list.add((DBColumn)part);
            }
        }

        @Override
        public void addSQL(DBSQLBuilder sql, long context) {
            for (Object part : this.parts) {
                if (part instanceof Column) {
                    DBColumn col = (DBColumn)part;
                    col.addSQL(sql, context);
                    continue;
                }
                sql.append(part.toString());
            }
        }
    }

    public static class DBTriggerGeneratedValue
    extends DBGeneratedValue {
        private final String triggerName;
        private final DBTableColumn[] sourceColumns;

        public DBTriggerGeneratedValue(DBRowSet table, String triggerName, DBTableColumn[] sourceColumns) {
            super(table.getDatabase());
            this.triggerName = triggerName;
            this.sourceColumns = sourceColumns;
        }

        @Override
        public boolean isModified(Record record) {
            for (int i = 0; i < this.sourceColumns.length; ++i) {
                if (!record.wasModified(this.sourceColumns[i])) continue;
                return true;
            }
            return false;
        }

        @Override
        public Object eval(Record record) {
            return ObjectUtils.NO_VALUE;
        }

        @Override
        public void addReferencedColumns(Set<DBColumn> list) {
            log.warn("No reference columns for trigger {}", (Object)this.triggerName);
        }

        @Override
        public void addSQL(DBSQLBuilder sql, long context) {
            log.error("Cannot add sql for value generated by trigger {}", (Object)this.triggerName);
            throw new NotSupportedException(this, "addSQL");
        }
    }
}

