/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.jsf.impl.util;

import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELException;
import javax.enterprise.context.ContextNotActiveException;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.apache.deltaspike.core.api.config.view.metadata.ViewConfigResolver;
import org.apache.deltaspike.core.api.config.view.navigation.NavigationParameterContext;
import org.apache.deltaspike.core.api.provider.BeanProvider;
import org.apache.deltaspike.core.util.ClassUtils;
import org.apache.deltaspike.core.util.StringUtils;
import org.apache.deltaspike.jsf.api.config.JsfModuleConfig;
import org.apache.deltaspike.jsf.api.config.base.JsfBaseConfig;
import org.apache.deltaspike.jsf.impl.listener.phase.WindowMetaData;
import org.apache.deltaspike.jsf.impl.message.FacesMessageEntry;
import org.apache.deltaspike.jsf.impl.util.RequestParameter;
import org.apache.deltaspike.jsf.impl.util.SharedStringBuilder;

public abstract class JsfUtils {
    private static final String SB_ADD_PARAMETER = "SB:" + JsfUtils.class + "#addParameter";

    public static <T> T getValueOfExpression(String expression, Class<T> targetType) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        return (T)facesContext.getApplication().evaluateExpressionGet(facesContext, expression, targetType);
    }

    public static String getValueOfExpressionAsString(String expression) {
        Object result = JsfUtils.getValueOfExpression(expression, Object.class);
        return result != null ? result.toString() : "null";
    }

    public static Set<RequestParameter> getViewConfigPageParameters() {
        ExternalContext externalContext = FacesContext.getCurrentInstance().getExternalContext();
        HashSet<RequestParameter> result = new HashSet<RequestParameter>();
        if (externalContext == null || externalContext.getRequestParameterValuesMap() == null || externalContext.getRequest() == null) {
            return result;
        }
        NavigationParameterContext navigationParameterContext = (NavigationParameterContext)BeanProvider.getContextualReference(NavigationParameterContext.class, (Annotation[])new Annotation[0]);
        for (Map.Entry entry : navigationParameterContext.getPageParameters().entrySet()) {
            result.add(new RequestParameter((String)entry.getKey(), new String[]{(String)entry.getValue()}));
        }
        return result;
    }

    public static String addPageParameters(ExternalContext externalContext, String url, boolean encodeValues) {
        StringBuilder finalUrl = new StringBuilder(url);
        boolean existingParameters = url.contains("?");
        for (RequestParameter requestParam : JsfUtils.getViewConfigPageParameters()) {
            String key = requestParam.getKey();
            for (String parameterValue : requestParam.getValues()) {
                if (url.contains(key + "=" + parameterValue) || url.contains(key + "=" + JsfUtils.encodeURLParameterValue(parameterValue, externalContext))) continue;
                if (!existingParameters) {
                    finalUrl.append("?");
                    existingParameters = true;
                } else {
                    finalUrl.append("&");
                }
                JsfUtils.appendUrlParameter(finalUrl, key, parameterValue, encodeValues, externalContext);
            }
        }
        return finalUrl.toString();
    }

    public static String addParameter(ExternalContext externalContext, String url, boolean encodeValues, String name, String value) {
        if (url.contains(name + "=" + value) || url.contains(name + "=" + JsfUtils.encodeURLParameterValue(value, externalContext))) {
            return url;
        }
        StringBuilder finalUrl = SharedStringBuilder.get(SB_ADD_PARAMETER);
        finalUrl.append(url);
        if (url.contains("?")) {
            finalUrl.append("&");
        } else {
            finalUrl.append("?");
        }
        JsfUtils.appendUrlParameter(finalUrl, name, value, encodeValues, externalContext);
        return finalUrl.toString();
    }

    public static String addRequestParameters(ExternalContext externalContext, String url, boolean encodeValues) {
        if (externalContext.getRequestParameterValuesMap().isEmpty()) {
            return url;
        }
        StringBuilder finalUrl = new StringBuilder(url);
        boolean existingParameters = url.contains("?");
        for (Map.Entry entry : externalContext.getRequestParameterValuesMap().entrySet()) {
            for (String value : (String[])entry.getValue()) {
                if (url.contains((String)entry.getKey() + "=" + value) || url.contains((String)entry.getKey() + "=" + JsfUtils.encodeURLParameterValue(value, externalContext)) || StringUtils.isEmpty((String)((String)entry.getKey())) && StringUtils.isEmpty((String)value)) continue;
                if (!existingParameters) {
                    finalUrl.append("?");
                    existingParameters = true;
                } else {
                    finalUrl.append("&");
                }
                JsfUtils.appendUrlParameter(finalUrl, (String)entry.getKey(), value, encodeValues, externalContext);
            }
        }
        return finalUrl.toString();
    }

    protected static void appendUrlParameter(StringBuilder url, String name, String value, boolean encode, ExternalContext externalContext) {
        if (encode) {
            url.append(JsfUtils.encodeURLParameterValue(name, externalContext));
        } else {
            url.append(name);
        }
        url.append("=");
        if (encode) {
            url.append(JsfUtils.encodeURLParameterValue(value, externalContext));
        } else {
            url.append(value);
        }
    }

    public static String encodeURLParameterValue(String value, ExternalContext externalContext) {
        try {
            return URLEncoder.encode(value, externalContext.getResponseCharacterEncoding());
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedOperationException("Encoding type=" + externalContext.getResponseCharacterEncoding() + " not supported", e);
        }
    }

    public static ViewConfigResolver getViewConfigResolver() {
        return (ViewConfigResolver)BeanProvider.getContextualReference(ViewConfigResolver.class, (Annotation[])new Annotation[0]);
    }

    public static void saveFacesMessages(ExternalContext externalContext) {
        JsfModuleConfig jsfModuleConfig = (JsfModuleConfig)BeanProvider.getContextualReference(JsfModuleConfig.class, (Annotation[])new Annotation[0]);
        if (!jsfModuleConfig.isAlwaysKeepMessages()) {
            return;
        }
        try {
            WindowMetaData windowMetaData = (WindowMetaData)BeanProvider.getContextualReference(WindowMetaData.class, (Annotation[])new Annotation[0]);
            Map requestMap = externalContext.getRequestMap();
            CopyOnWriteArrayList facesMessageEntryList = (CopyOnWriteArrayList)requestMap.get(FacesMessageEntry.class.getName());
            if (facesMessageEntryList == null) {
                facesMessageEntryList = new CopyOnWriteArrayList();
            }
            windowMetaData.setFacesMessageEntryList(facesMessageEntryList);
        }
        catch (ContextNotActiveException e) {
            FacesContext.getCurrentInstance().getExternalContext().getFlash().setKeepMessages(true);
        }
    }

    public static void tryToRestoreMessages(FacesContext facesContext) {
        JsfModuleConfig jsfModuleConfig = (JsfModuleConfig)BeanProvider.getContextualReference(JsfModuleConfig.class, (Annotation[])new Annotation[0]);
        if (!jsfModuleConfig.isAlwaysKeepMessages()) {
            return;
        }
        try {
            WindowMetaData windowMetaData = (WindowMetaData)BeanProvider.getContextualReference(WindowMetaData.class, (Annotation[])new Annotation[0]);
            List<FacesMessageEntry> facesMessageEntryList = windowMetaData.getFacesMessageEntryList();
            ArrayList<FacesMessage> originalMessageList = new ArrayList<FacesMessage>(facesContext.getMessageList());
            if (facesMessageEntryList != null) {
                for (FacesMessageEntry messageEntry : facesMessageEntryList) {
                    if (!JsfUtils.isNewMessage(originalMessageList, messageEntry.getFacesMessage())) continue;
                    facesContext.addMessage(messageEntry.getComponentId(), messageEntry.getFacesMessage());
                }
                facesMessageEntryList.clear();
            }
        }
        catch (ContextNotActiveException contextNotActiveException) {
            // empty catch block
        }
    }

    public static Throwable getRootCause(Throwable throwable) {
        while ((ELException.class.isInstance(throwable) || FacesException.class.isInstance(throwable) || InvocationTargetException.class.isInstance(throwable)) && throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        return throwable;
    }

    public static boolean isNewMessage(List<FacesMessage> facesMessages, FacesMessage messageToCheck) {
        for (FacesMessage facesMessage : facesMessages) {
            if ((facesMessage.getSummary() == null || !facesMessage.getSummary().equals(messageToCheck.getSummary())) && (facesMessage.getSummary() != null || messageToCheck.getSummary() != null) || (facesMessage.getDetail() == null || !facesMessage.getDetail().equals(messageToCheck.getDetail())) && (facesMessage.getDetail() != null || messageToCheck.getDetail() != null)) continue;
            return false;
        }
        return true;
    }

    public static boolean isViewScopeDelegationEnabled() {
        return ClassUtils.tryToLoadClassForName((String)"javax.faces.view.ViewScoped") != null && JsfBaseConfig.ScopeCustomization.ViewDelegation.DELEGATE_TO_JSF != false;
    }

    public static void logWrongModuleUsage(String name) {
        Logger.getLogger(name).log(Level.WARNING, "You are using the JSF module for JSF 2.0/2.1 with JSF 2.2+ which might cause issues in your application in different areas. Please upgrade org.apache.deltaspike.modules:deltaspike-jsf-module-impl-ee6 to org.apache.deltaspike.modules:deltaspike-jsf-module-impl");
    }

    public static void addStaticNavigationParameter(NavigationParameterContext navigationParameterContext, String key, String value) {
        Map existingParameters = navigationParameterContext.getPageParameters();
        String existingValue = (String)existingParameters.get(key);
        if (existingValue != null && value != null) {
            return;
        }
        navigationParameterContext.addPageParameter(key, (Object)value);
    }
}

