/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.testcontrol.impl.mock;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Typed;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedMember;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.ProcessInjectionTarget;
import javax.enterprise.inject.spi.ProcessProducer;
import javax.enterprise.inject.spi.Producer;
import org.apache.deltaspike.core.spi.activation.Deactivatable;
import org.apache.deltaspike.core.util.ClassDeactivationUtils;
import org.apache.deltaspike.core.util.ServiceUtils;
import org.apache.deltaspike.testcontrol.impl.mock.MockAwareInjectionTargetWrapper;
import org.apache.deltaspike.testcontrol.impl.mock.MockAwareProducerWrapper;
import org.apache.deltaspike.testcontrol.spi.mock.MockFilter;

public class MockExtension
implements Extension,
Deactivatable {
    private Boolean isActivated = true;
    private List<MockFilter> mockFilters;

    protected void init(@Observes BeforeBeanDiscovery beforeBeanDiscovery) {
        this.isActivated = ClassDeactivationUtils.isActivated(this.getClass());
        this.mockFilters = ServiceUtils.loadServiceImplementations(MockFilter.class);
    }

    public <X> void onProcessInjectionTarget(@Observes ProcessInjectionTarget<X> processInjectionTarget, BeanManager beanManager) {
        if (!this.isActivated.booleanValue()) {
            return;
        }
        for (MockFilter mockFilter : this.mockFilters) {
            if (mockFilter.isMockedImplementationSupported(beanManager, (Annotated)processInjectionTarget.getAnnotatedType())) continue;
            return;
        }
        ArrayList<Annotation> qualifiers = new ArrayList<Annotation>();
        for (Annotation annotation : processInjectionTarget.getAnnotatedType().getAnnotations()) {
            if (!beanManager.isQualifier(annotation.annotationType())) continue;
            qualifiers.add(annotation);
        }
        Typed typed = (Typed)processInjectionTarget.getAnnotatedType().getAnnotation(Typed.class);
        ArrayList<Type> foundTypes = new ArrayList<Type>();
        if (typed != null) {
            Collections.addAll(foundTypes, typed.value());
        } else {
            foundTypes.addAll(this.extractTypes(processInjectionTarget.getAnnotatedType().getJavaClass()));
        }
        if (foundTypes.isEmpty()) {
            return;
        }
        InjectionTarget originalInjectionTarget = processInjectionTarget.getInjectionTarget();
        processInjectionTarget.setInjectionTarget(new MockAwareInjectionTargetWrapper(beanManager, originalInjectionTarget, foundTypes, qualifiers));
    }

    public <X, T> void onProcessProducer(@Observes ProcessProducer<X, T> processProducer, BeanManager beanManager) {
        if (!this.isActivated.booleanValue()) {
            return;
        }
        for (MockFilter mockFilter : this.mockFilters) {
            if (mockFilter.isMockedImplementationSupported(beanManager, (Annotated)processProducer.getAnnotatedMember())) continue;
            return;
        }
        Producer originalProducer = processProducer.getProducer();
        AnnotatedMember annotatedMember = processProducer.getAnnotatedMember();
        ArrayList<Annotation> qualifiers = new ArrayList<Annotation>();
        for (Annotation annotation : annotatedMember.getAnnotations()) {
            if (!beanManager.isQualifier(annotation.annotationType())) continue;
            qualifiers.add(annotation);
        }
        Typed typed = (Typed)annotatedMember.getAnnotation(Typed.class);
        ArrayList<Type> foundTypes = new ArrayList<Type>();
        if (typed != null) {
            Collections.addAll(foundTypes, typed.value());
        } else if (annotatedMember.getBaseType() instanceof Class) {
            foundTypes.addAll(this.extractTypes((Class)annotatedMember.getBaseType()));
        }
        if (foundTypes.isEmpty()) {
            return;
        }
        processProducer.setProducer(new MockAwareProducerWrapper(beanManager, originalProducer, foundTypes, qualifiers));
    }

    protected List<Type> extractTypes(Class currentClass) {
        ArrayList<Type> result = new ArrayList<Type>();
        for (Class c = currentClass; c != Object.class && c != null; c = c.getSuperclass()) {
            result.add(c);
        }
        Collections.addAll(result, currentClass.getInterfaces());
        return result;
    }
}

