/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.testcontrol.impl.jsf;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.el.ExpressionFactory;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.RequestScoped;
import org.apache.deltaspike.core.api.config.ConfigResolver;
import org.apache.deltaspike.core.util.metadata.AnnotationInstanceProvider;
import org.apache.deltaspike.testcontrol.impl.jsf.MyFacesTestBaseConfig;
import org.apache.deltaspike.testcontrol.spi.ExternalContainer;
import org.apache.deltaspike.testcontrol.spi.TestAware;
import org.apache.myfaces.mc.test.core.annotation.TestConfig;
import org.apache.myfaces.mc.test.core.runner.MyFacesContainer;
import org.junit.runners.model.TestClass;

@ApplicationScoped
public class MyFacesContainerAdapter
implements TestAware,
ExternalContainer {
    private static final TestConfig DEFAULT_TEST_CONFIG_LITERAL = (TestConfig)AnnotationInstanceProvider.of(TestConfig.class);
    protected MyFacesContainer mockedMyFacesTestContainer;
    protected Class testClass;
    protected Map<String, String> containerConfig = new HashMap<String, String>();

    public void boot() {
        final ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        this.mockedMyFacesTestContainer = new MyFacesContainer(new TestClass(this.testClass)){

            protected String getWebappResourcePath() {
                TestConfig testConfig = this.testClass.getJavaClass().getAnnotation(TestConfig.class);
                if (testConfig == null || DEFAULT_TEST_CONFIG_LITERAL.webappResourcePath().equals(testConfig.webappResourcePath())) {
                    return MyFacesTestBaseConfig.WEBAPP_RESOURCE_PATH;
                }
                return testConfig.webappResourcePath();
            }

            protected void setUpServletObjects() {
                MyFacesContainerAdapter.this.setCurrentClassLoader(originalClassLoader);
                super.setUpServletObjects();
            }

            protected void setUpWebConfigParams() {
                this.servletContext.addInitParameter("org.apache.myfaces.config.annotation.LifecycleProvider", "org.apache.myfaces.config.annotation.NoInjectionAnnotationLifecycleProvider");
                this.servletContext.addInitParameter("org.apache.myfaces.CHECKED_VIEWID_CACHE_ENABLED", "false");
                this.servletContext.addInitParameter(ExpressionFactory.class.getName(), "org.apache.el.ExpressionFactoryImpl");
                super.setUpWebConfigParams();
                MyFacesContainerAdapter.this.initContainerConfig();
                for (Map.Entry<String, String> entry : MyFacesContainerAdapter.this.containerConfig.entrySet()) {
                    this.servletContext.addInitParameter(entry.getKey(), entry.getValue());
                }
            }
        };
        this.mockedMyFacesTestContainer.setUp(new Object());
    }

    protected void setCurrentClassLoader(ClassLoader originalClassLoader) {
        Thread.currentThread().setContextClassLoader(originalClassLoader);
    }

    protected void initContainerConfig() {
        this.containerConfig = new HashMap<String, String>();
        for (Map.Entry entry : ConfigResolver.getAllProperties().entrySet()) {
            if (!((String)entry.getKey()).startsWith("org.apache.myfaces.") && !((String)entry.getKey()).startsWith("javax.faces.") && !((String)entry.getKey()).startsWith("facelets.")) continue;
            this.containerConfig.put((String)entry.getKey(), (String)entry.getValue());
        }
    }

    public void startScope(Class<? extends Annotation> scopeClass) {
        if (RequestScoped.class.equals(scopeClass)) {
            this.mockedMyFacesTestContainer.startRequest();
        }
    }

    public void stopScope(Class<? extends Annotation> scopeClass) {
        if (RequestScoped.class.equals(scopeClass)) {
            this.mockedMyFacesTestContainer.endRequest();
        }
    }

    public void shutdown() {
        if (this.mockedMyFacesTestContainer == null) {
            throw new IllegalStateException("During starting MyFaces-Core an exception happened.");
        }
        this.mockedMyFacesTestContainer.tearDown();
    }

    public int getOrdinal() {
        return 1000;
    }

    public void setTestClass(Class testClass) {
        this.testClass = testClass;
    }

    public void setTestMethod(Method method) {
    }
}

