/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils.actors;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.Executor;
import org.apache.activemq.artemis.api.core.ActiveMQInterruptedException;
import org.apache.activemq.artemis.utils.actors.ArtemisExecutor;
import org.apache.activemq.artemis.utils.actors.ProcessorBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrderedExecutor
extends ProcessorBase<Runnable>
implements ArtemisExecutor {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private boolean fair;

    public OrderedExecutor(Executor delegate) {
        super(delegate);
    }

    @Override
    public boolean isFair() {
        return this.fair;
    }

    @Override
    public OrderedExecutor setFair(boolean fair) {
        this.fair = fair;
        return this;
    }

    @Override
    protected final void doTask(Runnable task) {
        try {
            task.run();
            if (this.fair) {
                this.yield();
            }
        }
        catch (ActiveMQInterruptedException e) {
            logger.debug("Interrupted Thread", (Throwable)e);
        }
        catch (Throwable t) {
            logger.warn(t.getMessage(), t);
        }
    }

    @Override
    public final void execute(Runnable run) {
        this.task(run);
    }

    public String toString() {
        return "OrderedExecutor(tasks=" + String.valueOf(this.tasks) + ")";
    }
}

