/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.config.amqpBrokerConnectivity;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.activemq.artemis.core.config.TransformerConfiguration;

public final class AMQPFederationQueuePolicyElement
implements Serializable {
    private static final long serialVersionUID = 7519912064917015520L;
    private final Set<QueueMatch> includes = new HashSet<QueueMatch>();
    private final Set<QueueMatch> excludes = new HashSet<QueueMatch>();
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private String name;
    private boolean includeFederated;
    private Integer priorityAdjustment;
    private TransformerConfiguration transformerConfig;

    public String getName() {
        return this.name;
    }

    public AMQPFederationQueuePolicyElement setName(String name) {
        this.name = name;
        return this;
    }

    public Set<QueueMatch> getIncludes() {
        return this.includes;
    }

    public AMQPFederationQueuePolicyElement addToIncludes(String addressMatch, String queueMatch) {
        this.includes.add(new QueueMatch().setAddressMatch(addressMatch).setQueueMatch(queueMatch));
        return this;
    }

    public AMQPFederationQueuePolicyElement addInclude(QueueMatch match) {
        this.includes.add(match);
        return this;
    }

    public AMQPFederationQueuePolicyElement setIncludes(Set<QueueMatch> includes) {
        this.includes.clear();
        if (includes != null) {
            this.includes.addAll(includes);
        }
        return this;
    }

    public Set<QueueMatch> getExcludes() {
        return this.excludes;
    }

    public AMQPFederationQueuePolicyElement addExclude(QueueMatch match) {
        this.excludes.add(match);
        return this;
    }

    public AMQPFederationQueuePolicyElement addToExcludes(String addressMatch, String queueMatch) {
        this.excludes.add(new QueueMatch().setAddressMatch(addressMatch).setQueueMatch(queueMatch));
        return this;
    }

    public AMQPFederationQueuePolicyElement setExcludes(Set<QueueMatch> excludes) {
        this.excludes.clear();
        if (excludes != null) {
            this.excludes.addAll(excludes);
        }
        return this;
    }

    public AMQPFederationQueuePolicyElement addProperty(String key, String value) {
        this.properties.put(key, value);
        return this;
    }

    public AMQPFederationQueuePolicyElement addProperty(String key, Number value) {
        this.properties.put(key, value);
        return this;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public AMQPFederationQueuePolicyElement setProperties(Map<String, Object> properties) {
        this.properties.clear();
        if (properties != null) {
            this.properties.putAll(properties);
        }
        return this;
    }

    public boolean isIncludeFederated() {
        return this.includeFederated;
    }

    public AMQPFederationQueuePolicyElement setIncludeFederated(boolean includeFederated) {
        this.includeFederated = includeFederated;
        return this;
    }

    public Integer getPriorityAdjustment() {
        return this.priorityAdjustment;
    }

    public AMQPFederationQueuePolicyElement setPriorityAdjustment(Integer priorityAdjustment) {
        this.priorityAdjustment = priorityAdjustment;
        return this;
    }

    public AMQPFederationQueuePolicyElement setTransformerConfiguration(TransformerConfiguration transformerConfig) {
        this.transformerConfig = transformerConfig;
        return this;
    }

    public TransformerConfiguration getTransformerConfiguration() {
        return this.transformerConfig;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AMQPFederationQueuePolicyElement)) {
            return false;
        }
        AMQPFederationQueuePolicyElement that = (AMQPFederationQueuePolicyElement)o;
        return this.includeFederated == that.includeFederated && Objects.equals(this.name, that.name) && Objects.equals(this.includes, that.includes) && Objects.equals(this.excludes, that.excludes) && Objects.equals(this.priorityAdjustment, that.priorityAdjustment);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.includeFederated, this.includes, this.excludes, this.priorityAdjustment);
    }

    public static class QueueMatch
    implements Serializable {
        private static final long serialVersionUID = -1641189627591828008L;
        private String name;
        private String addressMatch;
        private String queueMatch;

        public String getName() {
            if (this.name == null) {
                return this.addressMatch + this.queueMatch;
            }
            return this.name;
        }

        public QueueMatch setName(String name) {
            this.name = name;
            return this;
        }

        public String getAddressMatch() {
            return this.addressMatch;
        }

        public QueueMatch setAddressMatch(String addressMatch) {
            this.addressMatch = addressMatch;
            return this;
        }

        public String getQueueMatch() {
            return this.queueMatch;
        }

        public QueueMatch setQueueMatch(String queueMatch) {
            this.queueMatch = queueMatch;
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof QueueMatch)) {
                return false;
            }
            QueueMatch matcher = (QueueMatch)o;
            return Objects.equals(this.queueMatch, matcher.queueMatch) && Objects.equals(this.addressMatch, matcher.addressMatch);
        }

        public int hashCode() {
            return Objects.hash(this.queueMatch, this.addressMatch);
        }
    }
}

