/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.util.function.BiConsumer;
import org.eclipse.jetty.util.CharsetStringBuilder;
import org.eclipse.jetty.util.TypeUtil;

class UrlParameterDecoder {
    private final BiConsumer<String, String> newFieldAdder;
    private final int maxLength;
    private final int maxKeys;
    private final boolean allowBadEncoding;
    private final boolean allowBadPercent;
    private final boolean allowTruncatedEncoding;
    private final CharsetStringBuilder builder;
    private String name;
    private int keyCount;
    private int charCount;

    public UrlParameterDecoder(CharsetStringBuilder charsetStringBuilder, BiConsumer<String, String> newFieldAdder) {
        this(charsetStringBuilder, newFieldAdder, -1, -1);
    }

    public UrlParameterDecoder(CharsetStringBuilder charsetStringBuilder, BiConsumer<String, String> newFieldAdder, int maxLength, int maxKeys) {
        this(charsetStringBuilder, newFieldAdder, maxLength, maxKeys, false, false, false);
    }

    public UrlParameterDecoder(CharsetStringBuilder charsetStringBuilder, BiConsumer<String, String> newFieldAdder, int maxLength, int maxKeys, boolean allowBadEncoding, boolean allowBadPercent, boolean allowTruncatedEncoding) {
        this.builder = charsetStringBuilder;
        this.newFieldAdder = newFieldAdder;
        this.maxLength = maxLength;
        this.maxKeys = maxKeys;
        this.allowBadEncoding = allowBadEncoding;
        this.allowBadPercent = allowBadPercent;
        this.allowTruncatedEncoding = allowTruncatedEncoding;
    }

    public boolean parse(CharSequence charSequence) throws IOException {
        if (charSequence instanceof String) {
            String s = (String)charSequence;
            return this.parseCompletely(new StringCharIterator(s));
        }
        return this.parseCompletely(new CharSequenceCharIterator(charSequence));
    }

    public boolean parse(CharSequence charSequence, int offset, int length) throws IOException {
        if (charSequence instanceof String) {
            String s = (String)charSequence;
            return this.parseCompletely(new StringCharIterator(s, offset, length));
        }
        return this.parseCompletely(new CharSequenceCharIterator(charSequence, offset, length));
    }

    public boolean parse(InputStream input, Charset charset) throws IOException {
        return this.parse(new InputStreamReader(input, charset));
    }

    public boolean parse(Reader reader) throws IOException {
        return this.parseCompletely(new ReaderCharIterator(reader));
    }

    private boolean parseCompletely(CharIterator iter) throws IOException {
        int i;
        while ((i = iter.next()) >= 0) {
            char c = (char)i;
            if (this.maxLength >= 0 && ++this.charCount > this.maxLength) {
                throw new IllegalStateException("Form is larger than max length " + this.maxLength);
            }
            if (this.parseChar(c, iter)) continue;
            break;
        }
        this.complete();
        return this.builder.hasCodingErrors();
    }

    private boolean parseChar(char c, CharIterator iter) throws IOException {
        switch (c) {
            case '&': {
                String str = this.takeBuiltString();
                if (this.name == null) {
                    this.onNewField(str, "");
                    break;
                }
                this.onNewField(this.name, str);
                this.name = null;
                break;
            }
            case '=': {
                if (this.name == null) {
                    this.name = this.takeBuiltString();
                    break;
                }
                this.builder.append(c);
                break;
            }
            case '+': {
                this.builder.append(' ');
                break;
            }
            case '%': {
                int hi = iter.next();
                if (hi == -1) {
                    return this.handleIncompletePctEncoding(hi);
                }
                int lo = iter.next();
                if (lo == -1) {
                    return this.handleIncompletePctEncoding(hi);
                }
                try {
                    UrlParameterDecoder.decodeHexByteTo(this.builder, (char)hi, (char)lo);
                }
                catch (NumberFormatException e) {
                    boolean replaced = this.builder.replaceIncomplete();
                    if (replaced && !this.allowBadEncoding || !this.allowBadPercent) {
                        throw new IllegalArgumentException(this.notValidPctEncoding((char)hi, (char)lo));
                    }
                    if (hi == 38 || this.name == null && hi == 61) {
                        if (!replaced) {
                            this.builder.append('%');
                        }
                        this.parseChar((char)hi, iter);
                        this.parseChar((char)lo, iter);
                        break;
                    }
                    if (lo == 38 || this.name == null && lo == 61) {
                        if (!replaced) {
                            this.builder.append('%');
                            this.builder.append((char)hi);
                        }
                        this.parseChar((char)lo, iter);
                        break;
                    }
                    if (replaced) break;
                    this.builder.append('%');
                    this.builder.append((char)hi);
                    this.builder.append((char)lo);
                }
                break;
            }
            default: {
                this.builder.append(c);
            }
        }
        return true;
    }

    private boolean handleIncompletePctEncoding(int hi) {
        if (this.builder.replaceIncomplete()) {
            if (!this.allowBadEncoding || !this.allowBadPercent) {
                throw new IllegalArgumentException(this.notValidPctEncoding((char)hi, '\u0000'));
            }
            return false;
        }
        if (this.allowBadPercent) {
            this.builder.append('%');
            if (hi != -1) {
                this.builder.append((char)hi);
            }
            return true;
        }
        throw new IllegalArgumentException(this.notValidPctEncoding((char)hi, '\u0000'));
    }

    private static void decodeHexByteTo(CharsetStringBuilder buffer, char hi, char lo) {
        buffer.append((byte)((TypeUtil.convertHexDigit(hi) << 4) + TypeUtil.convertHexDigit(lo)));
    }

    private void complete() throws CharacterCodingException {
        if (this.name != null) {
            String value = this.takeBuiltString();
            this.onNewField(this.name, value);
        } else if (this.builder.length() > 0) {
            this.name = this.takeBuiltString();
            this.onNewField(this.name, "");
        }
    }

    private String notValidPctEncoding(char hi, char lo) {
        return "Not valid encoding '%%%c%c'".formatted(Character.valueOf(hi != '\u0000' ? hi : (char)'?'), Character.valueOf(lo != '\u0000' ? lo : (char)'?'));
    }

    private String takeBuiltString() throws CharacterCodingException {
        if (!(this.allowBadEncoding || this.allowBadPercent || this.allowTruncatedEncoding)) {
            String result = this.builder.build(false);
            this.builder.reset();
            return result;
        }
        boolean codingError = this.builder.hasCodingErrors();
        if (codingError && !this.allowBadEncoding) {
            return this.builder.build(false);
        }
        if (this.builder.replaceIncomplete() && !this.allowTruncatedEncoding) {
            return this.builder.build(false);
        }
        String result = this.builder.build(true);
        this.builder.reset();
        return result;
    }

    private void onNewField(String name, String value) {
        if (name == null || name.isEmpty()) {
            return;
        }
        ++this.keyCount;
        this.newFieldAdder.accept(name, value);
        if (this.maxKeys >= 0 && this.keyCount > this.maxKeys) {
            throw new IllegalStateException(String.format("Form with too many keys [%d > %d]", this.keyCount, this.maxKeys));
        }
    }

    static class StringCharIterator
    implements CharIterator {
        private final char[] str;
        private final int end;
        private int idx;

        StringCharIterator(String str) {
            this(str, 0, str.length());
        }

        StringCharIterator(String str, int offset, int length) {
            this.str = str.toCharArray();
            this.end = offset + length;
            this.idx = offset;
        }

        @Override
        public int next() {
            if (this.idx >= this.end) {
                return -1;
            }
            return this.str[this.idx++];
        }
    }

    static interface CharIterator {
        public int next() throws IOException;
    }

    static class CharSequenceCharIterator
    implements CharIterator {
        private final CharSequence str;
        private final int end;
        private int idx;

        CharSequenceCharIterator(CharSequence str) {
            this(str, 0, str.length());
        }

        CharSequenceCharIterator(CharSequence str, int offset, int length) {
            this.str = str;
            this.end = offset + length;
            this.idx = offset;
        }

        @Override
        public int next() {
            if (this.idx >= this.end) {
                return -1;
            }
            return this.str.charAt(this.idx++);
        }
    }

    static class ReaderCharIterator
    implements CharIterator {
        private final Reader reader;
        private final CharBuffer buffer;

        ReaderCharIterator(Reader reader) {
            this.reader = reader;
            this.buffer = CharBuffer.allocate(128);
            this.buffer.flip();
        }

        @Override
        public int next() throws IOException {
            if (!this.buffer.hasRemaining()) {
                this.buffer.clear();
                if (this.reader.read(this.buffer) == -1) {
                    return -1;
                }
                this.buffer.flip();
            }
            return this.buffer.get();
        }
    }
}

