/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.plugin.impl;

import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.activemq.artemis.api.core.ActiveMQDisconnectedException;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyAcceptor;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyServerConnection;
import org.apache.activemq.artemis.core.remoting.server.RemotingService;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerBasePlugin;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.remoting.Acceptor;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionPeriodicExpiryPlugin
implements ActiveMQServerBasePlugin {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private String name;
    private long periodSeconds = TimeUnit.MINUTES.toSeconds(15L);
    private int accuracyWindowSeconds = 30;
    private String acceptorMatchRegex;
    private ScheduledExecutorService executor;
    private RemotingService remotingService;
    private Pattern matchPattern;
    private ScheduledFuture<?> task;

    @Override
    public void registered(ActiveMQServer server) {
        this.sanityCheckConfig();
        this.executor = server.getScheduledPool();
        this.remotingService = server.getRemotingService();
        this.matchPattern = Pattern.compile(this.acceptorMatchRegex);
        this.task = this.executor.scheduleWithFixedDelay(() -> {
            try {
                long currentTime = System.currentTimeMillis();
                for (Acceptor acceptor : this.remotingService.getAcceptors().values()) {
                    if (!this.matchPattern.matcher(acceptor.getName()).matches() || !(acceptor instanceof NettyAcceptor)) continue;
                    NettyAcceptor nettyAcceptor = (NettyAcceptor)acceptor;
                    for (NettyServerConnection nettyServerConnection : nettyAcceptor.getConnections().values()) {
                        RemotingConnection remotingConnection = this.remotingService.getConnection(nettyServerConnection.getID());
                        if (remotingConnection == null || currentTime <= remotingConnection.getCreationTime() + this.periodSeconds) continue;
                        this.executor.schedule(() -> {
                            this.remotingService.removeConnection(remotingConnection.getID());
                            remotingConnection.fail((ActiveMQException)new ActiveMQDisconnectedException("terminated by session expiry plugin"));
                        }, (long)RandomUtil.randomMax((int)this.accuracyWindowSeconds), TimeUnit.SECONDS);
                    }
                }
            }
            catch (Exception trapToStayScheduled) {
                logger.debug("error on connection expiry plugin scheduled task, will retry", (Throwable)trapToStayScheduled);
            }
        }, this.accuracyWindowSeconds, this.accuracyWindowSeconds, TimeUnit.SECONDS);
    }

    @Override
    public void unregistered(ActiveMQServer server) {
        if (this.task != null) {
            this.task.cancel(true);
        }
    }

    @Override
    public void init(Map<String, String> properties) {
        this.name = properties.getOrDefault("name", this.name);
        this.periodSeconds = Long.parseLong(properties.getOrDefault("periodSeconds", Long.toString(this.periodSeconds)));
        this.accuracyWindowSeconds = Integer.parseInt(properties.getOrDefault("accuracyWindowSeconds", Long.toString(this.accuracyWindowSeconds)));
        this.acceptorMatchRegex = properties.getOrDefault("acceptorMatchRegex", this.acceptorMatchRegex);
        this.sanityCheckConfig();
    }

    private void sanityCheckConfig() {
        if (this.accuracyWindowSeconds <= 0) {
            throw new IllegalArgumentException("accuracyWindowSeconds must be > 0");
        }
        if (this.acceptorMatchRegex == null) {
            throw new IllegalArgumentException("acceptorMatchRegex must be configured");
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getPeriodSeconds() {
        return this.periodSeconds;
    }

    public void setPeriodSeconds(long periodSeconds) {
        this.periodSeconds = periodSeconds;
    }

    public int getAccuracyWindowSeconds() {
        return this.accuracyWindowSeconds;
    }

    public void setAccuracyWindowSeconds(int accuracyWindowSeconds) {
        this.accuracyWindowSeconds = accuracyWindowSeconds;
    }

    public void setAcceptorMatchRegex(String acceptorMatchRegex) {
        this.acceptorMatchRegex = acceptorMatchRegex;
    }

    public String getAcceptorMatchRegex() {
        return this.acceptorMatchRegex;
    }
}

