/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.core.impl;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.util.IndexedXMLObjectChildrenList;
import org.opensaml.saml.common.AbstractSignableSAMLObject;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.saml2.core.Advice;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.opensaml.saml.saml2.core.AuthnStatement;
import org.opensaml.saml.saml2.core.AuthzDecisionStatement;
import org.opensaml.saml.saml2.core.Conditions;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.Statement;
import org.opensaml.saml.saml2.core.Subject;

public class AssertionImpl
extends AbstractSignableSAMLObject
implements Assertion {
    private SAMLVersion version = SAMLVersion.VERSION_20;
    private Instant issueInstant;
    private String id;
    private Issuer issuer;
    private Subject subject;
    private Conditions conditions;
    private Advice advice;
    private final IndexedXMLObjectChildrenList<Statement> statements = new IndexedXMLObjectChildrenList((XMLObject)this);

    protected AssertionImpl(String namespaceURI, String elementLocalName, String namespacePrefix) {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    public SAMLVersion getVersion() {
        return this.version;
    }

    public void setVersion(SAMLVersion newVersion) {
        this.version = (SAMLVersion)this.prepareForAssignment(this.version, newVersion);
    }

    public Instant getIssueInstant() {
        return this.issueInstant;
    }

    public void setIssueInstant(Instant newIssueInstance) {
        this.issueInstant = (Instant)this.prepareForAssignment(this.issueInstant, newIssueInstance);
    }

    public String getID() {
        return this.id;
    }

    public void setID(String newID) {
        String oldID = this.id;
        this.id = this.prepareForAssignment(this.id, newID);
        this.registerOwnID(oldID, this.id);
    }

    public Issuer getIssuer() {
        return this.issuer;
    }

    public void setIssuer(Issuer newIssuer) {
        this.issuer = (Issuer)this.prepareForAssignment((XMLObject)this.issuer, (XMLObject)newIssuer);
    }

    public Subject getSubject() {
        return this.subject;
    }

    public void setSubject(Subject newSubject) {
        this.subject = (Subject)this.prepareForAssignment((XMLObject)this.subject, (XMLObject)newSubject);
    }

    public Conditions getConditions() {
        return this.conditions;
    }

    public void setConditions(Conditions newConditions) {
        this.conditions = (Conditions)this.prepareForAssignment((XMLObject)this.conditions, (XMLObject)newConditions);
    }

    public Advice getAdvice() {
        return this.advice;
    }

    public void setAdvice(Advice newAdvice) {
        this.advice = (Advice)this.prepareForAssignment((XMLObject)this.advice, (XMLObject)newAdvice);
    }

    public List<Statement> getStatements() {
        return this.statements;
    }

    public List<Statement> getStatements(QName typeOrName) {
        return this.statements.subList(typeOrName);
    }

    public List<AuthnStatement> getAuthnStatements() {
        QName statementQName = new QName("urn:oasis:names:tc:SAML:2.0:assertion", "AuthnStatement", "saml2");
        return this.statements.subList(statementQName);
    }

    public List<AuthzDecisionStatement> getAuthzDecisionStatements() {
        QName statementQName = new QName("urn:oasis:names:tc:SAML:2.0:assertion", "AuthzDecisionStatement", "saml2");
        return this.statements.subList(statementQName);
    }

    public List<AttributeStatement> getAttributeStatements() {
        QName statementQName = new QName("urn:oasis:names:tc:SAML:2.0:assertion", "AttributeStatement", "saml2");
        return this.statements.subList(statementQName);
    }

    public String getSignatureReferenceID() {
        return this.id;
    }

    public List<XMLObject> getOrderedChildren() {
        ArrayList<Object> children = new ArrayList<Object>();
        children.add(this.issuer);
        if (this.getSignature() != null) {
            children.add(this.getSignature());
        }
        children.add(this.subject);
        children.add(this.conditions);
        children.add(this.advice);
        children.addAll((Collection<Object>)this.statements);
        return Collections.unmodifiableList(children);
    }
}

