/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl2.scripting;

import java.io.StringWriter;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import junit.framework.TestCase;
import org.apache.commons.jexl2.scripting.JexlScriptEngineFactory;

public class JexlScriptEngineOptionalTest
extends TestCase {
    private final JexlScriptEngineFactory factory = new JexlScriptEngineFactory();
    private final ScriptEngineManager manager = new ScriptEngineManager();
    private final ScriptEngine engine = this.manager.getEngineByName("jexl");

    public void testOutput() throws Exception {
        String output = this.factory.getOutputStatement("foo\u00a9bar");
        JexlScriptEngineOptionalTest.assertEquals((String)"JEXL.out.print('foo\\u00a9bar')", (String)output);
        StringWriter outContent = new StringWriter();
        this.engine.getContext().setWriter(outContent);
        this.engine.eval(output);
        JexlScriptEngineOptionalTest.assertEquals((String)"foo\u00a9bar", (String)outContent.toString());
    }

    public void testError() throws Exception {
        String error = "JEXL.err.print('ERROR')";
        StringWriter outContent = new StringWriter();
        this.engine.getContext().setErrorWriter(outContent);
        this.engine.eval(error);
        JexlScriptEngineOptionalTest.assertEquals((String)"ERROR", (String)outContent.toString());
    }

    public void testCompilable() throws Exception {
        JexlScriptEngineOptionalTest.assertTrue((String)"Engine should implement Compilable", (boolean)(this.engine instanceof Compilable));
        Compilable cengine = (Compilable)((Object)this.engine);
        CompiledScript script = cengine.compile("40 + 2");
        JexlScriptEngineOptionalTest.assertEquals((Object)42, (Object)script.eval());
        JexlScriptEngineOptionalTest.assertEquals((Object)42, (Object)script.eval());
    }
}

