/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jci;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import junit.framework.TestCase;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractTestCase
extends TestCase {
    private final Log log = LogFactory.getLog(AbstractTestCase.class);
    protected File directory;

    protected void setUp() throws Exception {
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.SimpleLog");
        this.directory = this.createTempDirectory();
        AbstractTestCase.assertTrue((boolean)this.directory.exists());
        AbstractTestCase.assertTrue((boolean)this.directory.isDirectory());
    }

    protected File createDirectory(String pName) throws Exception {
        File newDirectory = new File(this.directory, pName);
        AbstractTestCase.assertTrue((boolean)newDirectory.mkdir());
        AbstractTestCase.assertTrue((boolean)newDirectory.exists());
        AbstractTestCase.assertTrue((boolean)newDirectory.isDirectory());
        return newDirectory;
    }

    protected File writeFile(String pName, byte[] pData) throws Exception {
        File file = new File(this.directory, pName);
        File parent = file.getParentFile();
        if (!parent.mkdirs() && !parent.isDirectory()) {
            throw new IOException("could not create" + parent);
        }
        this.log.debug((Object)("writing file " + pName + " (" + pData.length + " bytes)"));
        FileOutputStream os = new FileOutputStream(file);
        os.write(pData);
        os.close();
        AbstractTestCase.assertTrue((boolean)file.exists());
        AbstractTestCase.assertTrue((boolean)file.isFile());
        return file;
    }

    protected File writeFile(String pName, String pText) throws Exception {
        File file = new File(this.directory, pName);
        File parent = file.getParentFile();
        if (!parent.mkdirs() && !parent.isDirectory()) {
            throw new IOException("could not create" + parent);
        }
        this.log.debug((Object)("writing " + file));
        FileWriter writer = new FileWriter(file);
        writer.write(pText);
        writer.close();
        AbstractTestCase.assertTrue((boolean)file.exists());
        AbstractTestCase.assertTrue((boolean)file.isFile());
        return file;
    }

    protected void delay() {
        try {
            Thread.sleep(1500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected File createTempDirectory() throws IOException {
        File tempFile = File.createTempFile("jci", null);
        if (!tempFile.delete()) {
            throw new IOException();
        }
        if (!tempFile.mkdir()) {
            throw new IOException();
        }
        return tempFile;
    }

    protected void tearDown() throws Exception {
        FileUtils.deleteDirectory((File)this.directory);
    }
}

