/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2.managed;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.StatementEventListener;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;
import org.apache.commons.dbcp2.managed.LocalXAConnectionFactory;

public class TesterBasicXAConnection
implements XAConnection {
    public Connection conn;
    public ConnectionHandle handle;
    public List<ConnectionEventListener> listeners = new LinkedList<ConnectionEventListener>();
    public AtomicInteger closeCounter;

    public TesterBasicXAConnection(Connection conn, AtomicInteger closeCounter) {
        this.conn = conn;
        this.closeCounter = closeCounter;
    }

    public TesterBasicXAConnection(Connection conn) {
        this(conn, null);
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.conn == null) {
            SQLException e = new SQLException("XAConnection closed");
            this.notifyConnectionErrorOccurred(e);
            throw e;
        }
        try {
            if (this.handle != null) {
                this.closeHandle();
                this.conn.clearWarnings();
            }
        }
        catch (SQLException e) {
            this.notifyConnectionErrorOccurred(e);
            throw e;
        }
        this.handle = new ConnectionHandle(this.conn, this);
        Connection proxy = (Connection)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{Connection.class}, (InvocationHandler)this.handle);
        return proxy;
    }

    protected void closeHandle() throws SQLException {
        this.handle.closeHandle();
        if (!this.conn.getAutoCommit()) {
            try {
                this.conn.rollback();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        this.handle = null;
    }

    @Override
    public void close() throws SQLException {
        if (this.handle != null) {
            this.closeHandle();
        }
        try {
            this.conn.close();
            if (this.closeCounter != null) {
                this.closeCounter.incrementAndGet();
            }
        }
        finally {
            this.conn = null;
        }
    }

    @Override
    public XAResource getXAResource() throws SQLException {
        return new LocalXAConnectionFactory.LocalXAResource(this.conn);
    }

    @Override
    public void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.listeners.add(connectionEventListener);
    }

    @Override
    public void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.listeners.remove(connectionEventListener);
    }

    @Override
    public void addStatementEventListener(StatementEventListener listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeStatementEventListener(StatementEventListener listener) {
        throw new UnsupportedOperationException();
    }

    protected void notifyConnectionClosed() {
        ConnectionEvent event = new ConnectionEvent(this);
        ArrayList<ConnectionEventListener> copy = new ArrayList<ConnectionEventListener>(this.listeners);
        for (ConnectionEventListener listener : copy) {
            listener.connectionClosed(event);
        }
    }

    protected void notifyConnectionErrorOccurred(SQLException e) {
        ConnectionEvent event = new ConnectionEvent(this, e);
        ArrayList<ConnectionEventListener> copy = new ArrayList<ConnectionEventListener>(this.listeners);
        for (ConnectionEventListener listener : copy) {
            listener.connectionErrorOccurred(event);
        }
    }

    public static class ConnectionHandle
    implements InvocationHandler {
        public Connection conn;
        public TesterBasicXAConnection xaconn;

        public ConnectionHandle(Connection conn, TesterBasicXAConnection xaconn) {
            this.conn = conn;
            this.xaconn = xaconn;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            if (methodName.equals("hashCode")) {
                return System.identityHashCode(proxy);
            }
            if (methodName.equals("equals")) {
                return proxy == args[0];
            }
            if (methodName.equals("isClosed")) {
                return this.conn == null;
            }
            if (methodName.equals("close")) {
                return this.close();
            }
            if (this.conn == null) {
                throw new SQLException("Connection closed");
            }
            try {
                return method.invoke((Object)this.conn, args);
            }
            catch (InvocationTargetException e) {
                Throwable te = e.getTargetException();
                if (te instanceof SQLException) {
                    this.xaconn.notifyConnectionErrorOccurred((SQLException)te);
                }
                throw te;
            }
        }

        protected Object close() throws SQLException {
            if (this.conn != null) {
                this.conn.clearWarnings();
                this.conn = null;
                this.xaconn.handle = null;
                this.xaconn.notifyConnectionClosed();
            }
            return null;
        }

        public void closeHandle() {
            this.conn = null;
        }
    }
}

