/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import org.apache.commons.compress.archivers.zip.ZipLong;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ZipLongTest {
    ZipLongTest() {
    }

    @Test
    void testClone() {
        ZipLong s1 = new ZipLong(42);
        ZipLong s2 = (ZipLong)s1.clone();
        Assertions.assertNotSame((Object)s1, (Object)s2);
        Assertions.assertEquals((Object)s1, (Object)s2);
        Assertions.assertEquals((long)s1.getValue(), (long)s2.getValue());
    }

    @Test
    void testEquals() {
        ZipLong zl = new ZipLong(305419896);
        ZipLong zl2 = new ZipLong(305419896);
        ZipLong zl3 = new ZipLong(-2023406815);
        Assertions.assertEquals((Object)zl, (Object)zl, (String)"reflexive");
        Assertions.assertEquals((Object)zl, (Object)zl2, (String)"works");
        Assertions.assertNotEquals((Object)zl, (Object)zl3, (String)"works, part two");
        Assertions.assertEquals((Object)zl2, (Object)zl, (String)"symmetric");
        Assertions.assertNotEquals(null, (Object)zl, (String)"null handling");
        Assertions.assertNotEquals((Object)zl, (Object)4660, (String)"non ZipLong handling");
    }

    @Test
    void testFromBytes() {
        byte[] val = new byte[]{120, 86, 52, 18};
        ZipLong zl = new ZipLong(val);
        Assertions.assertEquals((long)305419896L, (long)zl.getValue(), (String)"value from bytes");
    }

    @Test
    void testPut() {
        byte[] arr = new byte[5];
        ZipLong.putLong((long)305419896L, (byte[])arr, (int)1);
        Assertions.assertEquals((int)120, (int)arr[1], (String)"first byte getBytes");
        Assertions.assertEquals((int)86, (int)arr[2], (String)"second byte getBytes");
        Assertions.assertEquals((int)52, (int)arr[3], (String)"third byte getBytes");
        Assertions.assertEquals((int)18, (int)arr[4], (String)"fourth byte getBytes");
    }

    @Test
    void testSign() {
        ZipLong zl = new ZipLong(new byte[]{-1, -1, -1, -1});
        Assertions.assertEquals((long)0xFFFFFFFFL, (long)zl.getValue());
        Assertions.assertEquals((int)-1, (int)zl.getIntValue());
        zl = new ZipLong(0xFFFFFFFFL);
        Assertions.assertEquals((long)0xFFFFFFFFL, (long)zl.getValue());
        zl = new ZipLong(-1);
        Assertions.assertEquals((long)-1L, (long)zl.getValue());
    }

    @Test
    void testToBytes() {
        ZipLong zl = new ZipLong(305419896);
        byte[] result = zl.getBytes();
        Assertions.assertEquals((int)4, (int)result.length, (String)"length getBytes");
        Assertions.assertEquals((int)120, (int)result[0], (String)"first byte getBytes");
        Assertions.assertEquals((int)86, (int)result[1], (String)"second byte getBytes");
        Assertions.assertEquals((int)52, (int)result[2], (String)"third byte getBytes");
        Assertions.assertEquals((int)18, (int)result[3], (String)"fourth byte getBytes");
    }
}

