/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.undo;

import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.modeler.action.CreateDataMapAction;
import org.apache.cayenne.modeler.action.RemoveAction;
import org.apache.cayenne.modeler.event.DomainDisplayEvent;
import org.apache.cayenne.modeler.undo.CayenneUndoableEdit;

public class CreateDataMapUndoableEdit
extends CayenneUndoableEdit {
    private DataDomain domain;
    private DataMap map;

    public String getPresentationName() {
        return "Create DataMap";
    }

    public CreateDataMapUndoableEdit(DataDomain domain, DataMap map) {
        this.domain = domain;
        this.map = map;
    }

    public void redo() throws CannotRedoException {
        CreateDataMapAction action = (CreateDataMapAction)this.actionManager.getAction(CreateDataMapAction.getActionName());
        action.createDataMap(this.domain, this.map);
    }

    public void undo() throws CannotUndoException {
        RemoveAction action = (RemoveAction)this.actionManager.getAction(RemoveAction.getActionName());
        this.controller.fireDomainDisplayEvent(new DomainDisplayEvent((Object)this, this.domain));
        action.removeDataMap(this.domain, this.map);
    }
}

