/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.parser;

import java.util.Collection;
import java.util.Map;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.parser.ASTExists;
import org.apache.cayenne.exp.parser.ASTNotExists;
import org.apache.cayenne.exp.parser.AggregateConditionNode;
import org.apache.cayenne.exp.parser.Node;
import org.apache.cayenne.exp.parser.SimpleNode;

public abstract class ConditionNode
extends SimpleNode {
    public ConditionNode(int i) {
        super(i);
    }

    @Override
    protected boolean isValidParent(Node n) {
        return n instanceof AggregateConditionNode || n instanceof ASTExists || n instanceof ASTNotExists;
    }

    @Override
    protected Object evaluateNode(Object o) throws Exception {
        int requiredLen;
        int len = this.jjtGetNumChildren();
        if (len != (requiredLen = this.getRequiredChildrenCount())) {
            return Boolean.FALSE;
        }
        if (requiredLen == 0) {
            return this.evaluateSubNode(null, null);
        }
        Object[] evaluatedChildren = new Object[requiredLen];
        for (int i = 0; i < requiredLen; ++i) {
            evaluatedChildren[i] = this.evaluateChild(i, o);
        }
        Collection firstChild = evaluatedChildren[0];
        if (firstChild instanceof Map) {
            firstChild = ((Map)((Object)firstChild)).values();
        }
        if (firstChild instanceof Collection) {
            for (Object c : firstChild) {
                if (this.evaluateSubNode(c, evaluatedChildren) != Boolean.TRUE) continue;
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        return this.evaluateSubNode(firstChild, evaluatedChildren);
    }

    protected abstract int getRequiredChildrenCount();

    protected abstract Boolean evaluateSubNode(Object var1, Object[] var2) throws Exception;

    @Override
    public Expression exists() {
        return ExpressionFactory.exists(this);
    }

    @Override
    public Expression notExists() {
        return ExpressionFactory.notExists(this);
    }
}

