/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.sqlbuilder.sqltree;

import java.util.Objects;
import org.apache.cayenne.access.sqlbuilder.QuotingAppendable;
import org.apache.cayenne.access.sqlbuilder.sqltree.Node;
import org.apache.cayenne.access.sqlbuilder.sqltree.NodeType;
import org.apache.cayenne.map.DbAttribute;

public class ColumnNode
extends Node {
    protected final String table;
    protected final String column;
    protected final DbAttribute attribute;
    protected String alias;

    public ColumnNode(String table, String column, String alias, DbAttribute attribute) {
        super(NodeType.COLUMN);
        this.table = table;
        this.column = column;
        this.alias = alias;
        this.attribute = attribute;
    }

    @Override
    public QuotingAppendable append(QuotingAppendable buffer) {
        buffer.append(' ');
        if (this.table != null) {
            buffer.appendQuoted(this.table).append('.');
        }
        buffer.appendQuoted(this.column);
        if (this.alias != null) {
            buffer.append(' ').appendQuoted(this.alias);
        }
        return buffer;
    }

    public String getTable() {
        return this.table;
    }

    public String getColumn() {
        return this.column;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public DbAttribute getAttribute() {
        return this.attribute;
    }

    @Override
    public Node copy() {
        return new ColumnNode(this.table, this.column, this.alias, this.attribute);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ColumnNode that = (ColumnNode)o;
        return Objects.equals(this.table, that.table) && Objects.equals(this.column, that.column) && Objects.equals(this.alias, that.alias);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.table, this.column, this.alias);
    }
}

