/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project.validation;

import java.util.function.Supplier;
import org.apache.cayenne.map.EmbeddableAttribute;
import org.apache.cayenne.project.validation.ConfigurationNodeValidator;
import org.apache.cayenne.project.validation.Inspection;
import org.apache.cayenne.project.validation.ValidationConfig;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.validation.ValidationResult;

class EmbeddableAttributeValidator
extends ConfigurationNodeValidator<EmbeddableAttribute> {
    public EmbeddableAttributeValidator(Supplier<ValidationConfig> configSupplier) {
        super(configSupplier);
    }

    @Override
    public void validate(EmbeddableAttribute node, ValidationResult validationResult) {
        this.on(node, validationResult).performIfEnabled(Inspection.EMBEDDABLE_ATTRIBUTE_NO_NAME, this::checkForName).performIfEnabled(Inspection.EMBEDDABLE_ATTRIBUTE_NO_TYPE, this::checkForType);
    }

    private void checkForName(EmbeddableAttribute attribute, ValidationResult validationResult) {
        if (Util.isEmptyString(attribute.getName())) {
            this.addFailure(validationResult, attribute, "Unnamed EmbeddableAttribute", new Object[0]);
        }
    }

    private void checkForType(EmbeddableAttribute attribute, ValidationResult validationResult) {
        if (Util.isEmptyString(attribute.getType())) {
            this.addFailure(validationResult, attribute, "EmbeddableAttribute '%s' has no type", attribute.getName());
        }
    }
}

