/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.QueryDescriptor;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.editor.SelectPropertiesPanel;
import org.apache.cayenne.modeler.util.CellRenderers;
import org.apache.cayenne.modeler.util.Comparators;
import org.apache.cayenne.swing.components.JCayenneCheckBox;

public abstract class RawQueryPropertiesPanel
extends SelectPropertiesPanel {
    protected JCheckBox persistentObjects;
    protected JComboBox<ObjEntity> entities;

    public RawQueryPropertiesPanel(ProjectController mediator) {
        super(mediator);
    }

    @Override
    protected void initController() {
        super.initController();
        this.persistentObjects.addItemListener(e -> this.setFetchingPersistentObjects(this.persistentObjects.isSelected()));
        this.entities.addActionListener(event -> {
            ObjEntity entity = (ObjEntity)this.entities.getModel().getSelectedItem();
            this.setEntity(entity);
        });
    }

    protected PanelBuilder createPanelBuilder() {
        CellConstraints cc = new CellConstraints();
        FormLayout layout = new FormLayout("right:max(80dlu;pref), 3dlu, left:max(10dlu;pref), 3dlu, left:max(37dlu;pref), 3dlu, fill:max(147dlu;pref)", "p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p");
        PanelBuilder builder = new PanelBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.addSeparator("Select Properties", cc.xywh(1, 1, 7, 1));
        builder.addLabel("Result Caching:", cc.xy(1, 3));
        builder.add((Component)this.cacheStrategy, cc.xywh(3, 3, 5, 1));
        this.cacheGroupsLabel = builder.addLabel("Cache Group:", cc.xy(1, 7));
        builder.add((Component)this.cacheGroups.getComponent(), cc.xywh(3, 7, 5, 1));
        builder.addLabel("Fetch Persistent Objects:", cc.xy(1, 9));
        builder.add((Component)this.persistentObjects, cc.xy(3, 9));
        builder.add(this.entities, cc.xywh(5, 9, 3, 1));
        builder.addLabel("Fetch Offset, Rows:", cc.xy(1, 11));
        builder.add((Component)this.fetchOffset.getComponent(), cc.xywh(3, 11, 3, 1));
        builder.addLabel("Fetch Limit, Rows:", cc.xy(1, 13));
        builder.add((Component)this.fetchLimit.getComponent(), cc.xywh(3, 13, 3, 1));
        builder.addLabel("Page Size:", cc.xy(1, 15));
        builder.add((Component)this.pageSize.getComponent(), cc.xywh(3, 15, 3, 1));
        return builder;
    }

    @Override
    protected void initView() {
        super.initView();
        this.persistentObjects = new JCayenneCheckBox();
        this.entities = Application.getWidgetFactory().createUndoableComboBox();
        this.entities.setRenderer(CellRenderers.listRendererWithIcons());
        this.setLayout(new BorderLayout());
        this.add((Component)this.createPanelBuilder().getPanel(), "Center");
    }

    @Override
    public void initFromModel(QueryDescriptor query) {
        super.initFromModel(query);
        boolean fetchingDO = Boolean.valueOf(query.getProperties().get("cayenne.GenericSelectQuery.fetchingDataRows")) == false;
        this.persistentObjects.setSelected(fetchingDO);
        DataMap map = this.mediator.getCurrentDataMap();
        ArrayList<ObjEntity> objEntities = new ArrayList<ObjEntity>(map.getObjEntities());
        if (objEntities.size() > 1) {
            objEntities.sort(Comparators.getDataMapChildrenComparator());
        }
        this.entities.setEnabled(fetchingDO && this.isEnabled());
        DefaultComboBoxModel<ObjEntity> model = new DefaultComboBoxModel<ObjEntity>(objEntities.toArray(new ObjEntity[0]));
        model.setSelectedItem(this.getEntity(query));
        this.entities.setModel(model);
    }

    protected abstract void setEntity(ObjEntity var1);

    protected abstract ObjEntity getEntity(QueryDescriptor var1);

    protected void setFetchingPersistentObjects(boolean fetchingPersistentObjects) {
        this.entities.setEnabled(fetchingPersistentObjects && this.isEnabled());
        if (!fetchingPersistentObjects) {
            this.entities.getModel().setSelectedItem(null);
        }
        this.setQueryProperty("cayenne.GenericSelectQuery.fetchingDataRows", fetchingPersistentObjects ? Boolean.FALSE.toString() : Boolean.TRUE.toString());
    }
}

