/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.merge.token.model;

import org.apache.cayenne.dbsync.merge.context.MergerContext;
import org.apache.cayenne.dbsync.merge.factory.MergerTokenFactory;
import org.apache.cayenne.dbsync.merge.token.MergerToken;
import org.apache.cayenne.dbsync.merge.token.model.AbstractToModelToken;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.ObjEntity;

public class AddRelationshipToModel
extends AbstractToModelToken.Entity {
    public static final String COMMA_SEPARATOR = ", ";
    public static final int COMMA_SEPARATOR_LENGTH = ", ".length();
    private DbRelationship relationship;

    public AddRelationshipToModel(DbEntity entity, DbRelationship relationship) {
        super("Add Relationship", 125, entity);
        this.relationship = relationship;
    }

    public static String getTokenValue(DbRelationship rel) {
        Object attributes = "";
        if (rel.getJoins().size() == 1) {
            attributes = rel.getJoins().get(0).getTargetName();
        } else {
            for (DbJoin dbJoin : rel.getJoins()) {
                attributes = (String)attributes + dbJoin.getTargetName() + COMMA_SEPARATOR;
            }
            attributes = ((String)attributes).isEmpty() ? "{}" : "{" + ((String)attributes).substring(0, ((String)attributes).length() - COMMA_SEPARATOR_LENGTH) + "}";
        }
        return rel.getName() + " " + ((DbEntity)rel.getSourceEntity()).getName() + "->" + rel.getTargetEntityName() + "." + (String)attributes;
    }

    @Override
    public MergerToken createReverse(MergerTokenFactory factory) {
        return factory.createDropRelationshipToDb(this.getEntity(), this.relationship);
    }

    @Override
    public void execute(MergerContext context) {
        if (this.relationship.getName() == null) {
            this.relationship.setName(context.getNameGenerator().relationshipName(this.relationship));
        }
        this.getEntity().addRelationship(this.relationship);
        for (ObjEntity e : this.getMappedObjEntities()) {
            context.getEntityMergeSupport().synchronizeOnDbRelationshipAdded(e, this.relationship);
        }
        context.getDelegate().dbRelationshipAdded(this.relationship);
    }

    @Override
    public String getTokenValue() {
        return AddRelationshipToModel.getTokenValue(this.relationship);
    }
}

