/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.db2;

import org.apache.cayenne.access.sqlbuilder.sqltree.ColumnNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.FunctionNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.LimitOffsetNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.Node;
import org.apache.cayenne.access.sqlbuilder.sqltree.OpExpressionNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.TrimmingColumnNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.ValueNode;
import org.apache.cayenne.access.translator.select.BaseSQLTreeProcessor;
import org.apache.cayenne.dba.derby.sqltree.DerbyValueNode;
import org.apache.cayenne.dba.mysql.sqltree.MysqlLimitOffsetNode;

public class DB2SQLTreeProcessor
extends BaseSQLTreeProcessor {
    @Override
    protected void onLimitOffsetNode(Node parent, LimitOffsetNode child, int index) {
        MysqlLimitOffsetNode replacement = new MysqlLimitOffsetNode(child.getLimit(), child.getOffset());
        DB2SQLTreeProcessor.replaceChild(parent, index, replacement, false);
    }

    @Override
    protected void onColumnNode(Node parent, ColumnNode child, int index) {
        TrimmingColumnNode replacement = new TrimmingColumnNode(child);
        DB2SQLTreeProcessor.replaceChild(parent, index, replacement);
    }

    @Override
    protected void onValueNode(Node parent, ValueNode child, int index) {
        DerbyValueNode replacement = new DerbyValueNode(child.getValue(), child.isArray(), child.getAttribute(), child.isNeedBinding());
        DB2SQLTreeProcessor.replaceChild(parent, index, replacement, false);
    }

    @Override
    protected void onFunctionNode(Node parent, FunctionNode child, int index) {
        Node replacement = this.getReplacementForFunction(child);
        if (replacement != null) {
            DB2SQLTreeProcessor.replaceChild(parent, index, replacement);
        }
    }

    private Node getReplacementForFunction(FunctionNode child) {
        switch (child.getFunctionName()) {
            case "SUBSTRING": {
                return new FunctionNode("SUBSTR", child.getAlias(), true);
            }
            case "DAY_OF_MONTH": {
                return new FunctionNode("DAY", child.getAlias(), true);
            }
            case "DAY_OF_WEEK": {
                return new FunctionNode("DAYOFWEEK", child.getAlias(), true);
            }
            case "DAY_OF_YEAR": {
                return new FunctionNode("DAYOFYEAR", child.getAlias(), true);
            }
            case "CURRENT_DATE": 
            case "CURRENT_TIME": 
            case "CURRENT_TIMESTAMP": {
                return new FunctionNode(child.getFunctionName(), child.getAlias(), false);
            }
            case "CONCAT": {
                return new OpExpressionNode("||");
            }
        }
        return null;
    }
}

