/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog;

import java.util.ArrayList;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.util.CayenneTableModel;

public class DbJoinTableModel
extends CayenneTableModel<DbJoin> {
    static final int SOURCE = 0;
    static final int TARGET = 1;
    protected DbRelationship relationship;
    protected DbEntity source;
    protected DbEntity target;
    private boolean editable;

    public DbJoinTableModel(DbRelationship relationship, ProjectController mediator, Object src) {
        super(mediator, src, new ArrayList<DbJoin>(relationship.getJoins()));
        this.relationship = relationship;
        this.source = relationship.getSourceEntity();
        this.target = relationship.getTargetEntity();
    }

    public DbJoinTableModel(DbRelationship relationship, ProjectController mediator, Object src, boolean editable) {
        this(relationship, mediator, src);
        this.editable = editable;
    }

    @Override
    public Class getElementsClass() {
        return DbJoin.class;
    }

    public void commit() {
        this.relationship.setJoins(this.getObjectList());
    }

    public String getOrderingKey() {
        return null;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int column) {
        if (column == 0) {
            return this.relationship.getSourceEntity().getName();
        }
        if (column == 1) {
            return this.relationship.getTargetEntity().getName();
        }
        return "";
    }

    public DbJoin getJoin(int row) {
        return row >= 0 && row < this.objectList.size() ? (DbJoin)this.objectList.get(row) : null;
    }

    @Override
    public Object getValueAt(int row, int column) {
        DbJoin join = this.getJoin(row);
        if (join == null) {
            return null;
        }
        if (column == 0) {
            return join.getSourceName();
        }
        if (column == 1) {
            return join.getTargetName();
        }
        return null;
    }

    @Override
    public void setUpdatedValueAt(Object aValue, int row, int column) {
        DbJoin join = this.getJoin(row);
        if (join == null) {
            return;
        }
        String value = (String)aValue;
        if (column == 0) {
            if (this.source == null || this.source.getAttribute(value) == null) {
                value = null;
            }
            join.setSourceName(value);
        } else if (column == 1) {
            if (this.target == null || this.target.getAttribute(value) == null) {
                value = null;
            }
            join.setTargetName(value);
        }
        this.fireTableRowsUpdated(row, row);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (col == 0) {
            return this.relationship.getSourceEntity() != null && this.editable;
        }
        if (col == 1) {
            return this.relationship.getTargetEntity() != null && this.editable;
        }
        return false;
    }

    @Override
    public boolean isColumnSortable(int sortCol) {
        return true;
    }

    @Override
    public void sortByColumn(int sortCol, boolean isAscent) {
        switch (sortCol) {
            case 0: {
                this.sortByElementProperty("sourceName", isAscent);
                break;
            }
            case 1: {
                this.sortByElementProperty("targetName", isAscent);
            }
        }
    }
}

