/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.undo;

import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.apache.cayenne.modeler.util.CayenneTableModel;

public class CayenneTableModelUndoableEdit
extends AbstractUndoableEdit {
    private CayenneTableModel model;
    private Object oldValue;
    private Object newValue;
    private int row;
    private int col;

    @Override
    public String getPresentationName() {
        return "Cell Change";
    }

    public CayenneTableModelUndoableEdit(CayenneTableModel model, Object oldValue, Object newValue, int row, int col) {
        this.model = model;
        this.oldValue = oldValue;
        this.newValue = newValue;
        this.row = row;
        this.col = col;
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public void redo() throws CannotRedoException {
        this.model.setUpdatedValueAt(this.newValue, this.row, this.col);
        this.model.fireTableCellUpdated(this.row, this.col);
    }

    @Override
    public void undo() throws CannotUndoException {
        this.model.setUpdatedValueAt(this.oldValue, this.row, this.col);
        this.model.fireTableCellUpdated(this.row, this.col);
    }
}

