/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.codegen;

import java.util.Map;
import java.util.Set;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.modeler.pref.DataMapDefaults;

public class CustomPreferencesUpdater {
    private static final String OVERWRITE = "overwrite";
    private static final String PAIRS = "pairs";
    private static final String USE_PACKAGE_PATH = "usePackagePath";
    private static final String MODE = "mode";
    private static final String OUTPUT_PATTERN = "outputPattern";
    private static final String CREATE_PROPERTY_NAMES = "createPropertyNames";
    private Map<DataMap, DataMapDefaults> mapPreferences;

    public CustomPreferencesUpdater(Map<DataMap, DataMapDefaults> mapPreferences) {
        this.mapPreferences = mapPreferences;
    }

    public String getMode() {
        return (String)this.getProperty(Property.MODE);
    }

    public void setMode(String mode) {
        this.updatePreferences(Property.MODE, mode);
    }

    public String getSubclassTemplate() {
        return (String)this.getProperty(Property.SUBCLASS_TEMPLATE);
    }

    public void setSubclassTemplate(String subclassTemplate) {
        this.updatePreferences(Property.SUBCLASS_TEMPLATE, subclassTemplate);
    }

    public String getSuperclassTemplate() {
        return (String)this.getProperty(Property.SUPERCLASS_TEMPLATE);
    }

    public void setSuperclassTemplate(String superclassTemplate) {
        this.updatePreferences(Property.SUPERCLASS_TEMPLATE, superclassTemplate);
    }

    public Boolean getOverwrite() {
        return (Boolean)this.getProperty(Property.OVERWRITE);
    }

    public void setOverwrite(Boolean overwrite2) {
        this.updatePreferences(Property.OVERWRITE, overwrite2);
    }

    public Boolean getPairs() {
        return (Boolean)this.getProperty(Property.PAIRS);
    }

    public void setPairs(Boolean pairs) {
        this.updatePreferences(Property.PAIRS, pairs);
    }

    public Boolean getUsePackagePath() {
        return (Boolean)this.getProperty(Property.USE_PACKAGE_PATH);
    }

    public void setUsePackagePath(Boolean usePackagePath) {
        this.updatePreferences(Property.USE_PACKAGE_PATH, usePackagePath);
    }

    public String getOutputPattern() {
        return (String)this.getProperty(Property.OUTPUT_PATTERN);
    }

    public void setOutputPattern(String outputPattern) {
        this.updatePreferences(Property.OUTPUT_PATTERN, outputPattern);
    }

    public Boolean getCreatePropertyNames() {
        return (Boolean)this.getProperty(Property.CREATE_PROPERTY_NAMES);
    }

    public void setCreatePropertyNames(Boolean createPropertyNames) {
        this.updatePreferences(Property.CREATE_PROPERTY_NAMES, createPropertyNames);
    }

    private Object getProperty(Property property) {
        Object obj = null;
        Set<Map.Entry<DataMap, DataMapDefaults>> entities = this.mapPreferences.entrySet();
        block10: for (Map.Entry<DataMap, DataMapDefaults> entry : entities) {
            switch (property) {
                case MODE: {
                    obj = entry.getValue().getProperty(MODE);
                    continue block10;
                }
                case OUTPUT_PATTERN: {
                    obj = entry.getValue().getProperty(OUTPUT_PATTERN);
                    continue block10;
                }
                case SUBCLASS_TEMPLATE: {
                    obj = entry.getValue().getSubclassTemplate();
                    continue block10;
                }
                case SUPERCLASS_TEMPLATE: {
                    obj = entry.getValue().getSuperclassTemplate();
                    continue block10;
                }
                case OVERWRITE: {
                    obj = entry.getValue().getBooleanProperty(OVERWRITE);
                    continue block10;
                }
                case PAIRS: {
                    obj = entry.getValue().getBooleanProperty(PAIRS);
                    continue block10;
                }
                case USE_PACKAGE_PATH: {
                    obj = entry.getValue().getBooleanProperty(USE_PACKAGE_PATH);
                    continue block10;
                }
                case CREATE_PROPERTY_NAMES: {
                    obj = entry.getValue().getBooleanProperty(CREATE_PROPERTY_NAMES);
                    continue block10;
                }
            }
            throw new IllegalArgumentException("Bad type property: " + (Object)((Object)property));
        }
        return obj;
    }

    private void updatePreferences(Property property, Object value) {
        Set<Map.Entry<DataMap, DataMapDefaults>> entities = this.mapPreferences.entrySet();
        block10: for (Map.Entry<DataMap, DataMapDefaults> entry : entities) {
            switch (property) {
                case MODE: {
                    entry.getValue().setProperty(MODE, (String)value);
                    continue block10;
                }
                case OUTPUT_PATTERN: {
                    entry.getValue().setProperty(OUTPUT_PATTERN, (String)value);
                    continue block10;
                }
                case SUBCLASS_TEMPLATE: {
                    entry.getValue().setSubclassTemplate((String)value);
                    continue block10;
                }
                case SUPERCLASS_TEMPLATE: {
                    entry.getValue().setSuperclassTemplate((String)value);
                    continue block10;
                }
                case OVERWRITE: {
                    entry.getValue().setBooleanProperty(OVERWRITE, (Boolean)value);
                    continue block10;
                }
                case PAIRS: {
                    entry.getValue().setBooleanProperty(PAIRS, (Boolean)value);
                    continue block10;
                }
                case USE_PACKAGE_PATH: {
                    entry.getValue().setBooleanProperty(USE_PACKAGE_PATH, (Boolean)value);
                    continue block10;
                }
                case CREATE_PROPERTY_NAMES: {
                    entry.getValue().setBooleanProperty(CREATE_PROPERTY_NAMES, (Boolean)value);
                    continue block10;
                }
            }
            throw new IllegalArgumentException("Bad type property: " + (Object)((Object)property));
        }
    }

    static enum Property {
        SUBCLASS_TEMPLATE,
        SUPERCLASS_TEMPLATE,
        OVERWRITE,
        PAIRS,
        USE_PACKAGE_PATH,
        MODE,
        OUTPUT_PATTERN,
        CREATE_PROPERTY_NAMES;

    }
}

