/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.exceptions;

import org.apache.brooklyn.util.exceptions.Exceptions;

public class RuntimeInterruptedException
extends RuntimeException {
    private static final long serialVersionUID = 915050245927866175L;
    long interruptedThreadId;

    public RuntimeInterruptedException(String msg) {
        super(msg);
        this.checkThreadsAndInterrupt(null);
    }

    public RuntimeInterruptedException(Throwable cause) {
        super(cause);
        this.checkThreadsAndInterrupt(cause);
    }

    public RuntimeInterruptedException(String msg, Throwable cause) {
        super(msg, cause);
        this.checkThreadsAndInterrupt(cause);
    }

    protected boolean checkThreadsAndInterrupt(Throwable cause) {
        RuntimeInterruptedException anotherRuntime = cause == null ? null : Exceptions.getFirstThrowableOfType(cause, RuntimeInterruptedException.class);
        this.interruptedThreadId = anotherRuntime == null ? Thread.currentThread().getId() : anotherRuntime.interruptedThreadId;
        if (this.isFromCurrentThread()) {
            Thread.currentThread().interrupt();
            return true;
        }
        return false;
    }

    public boolean isFromCurrentThread() {
        return this.interruptedThreadId == Thread.currentThread().getId();
    }
}

