/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.core.task.ssh.internal;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.net.InetAddress;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.location.MachineLocation;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.objs.Configurable;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.location.AbstractLocation;
import org.apache.brooklyn.core.objs.BasicConfigurableObject;
import org.apache.brooklyn.core.resolve.jackson.WrappedValue;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.BrooklynNetworkUtils;
import org.apache.brooklyn.util.core.ClassLoaderUtils;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.internal.ssh.ShellTool;
import org.apache.brooklyn.util.core.internal.ssh.SshTool;
import org.apache.brooklyn.util.core.internal.ssh.sshj.SshjTool;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.core.task.ssh.ConnectionDefinition;
import org.apache.brooklyn.util.core.task.system.internal.ExecWithLoggingHelpers;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.net.Networking;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteExecTaskConfigHelper {

    public static class RemoteExecCapabilityFromDefinition
    implements RemoteExecCapability {
        private static final Logger logSsh = LoggerFactory.getLogger((String)"org.apache.brooklyn.SSH");
        private static final Logger LOG = LoggerFactory.getLogger(RemoteExecCapabilityFromDefinition.class);
        private final ConnectionDefinition definition;
        ManagementContext mgmt;
        protected InetAddress address;
        protected Map<String, Object> config;

        public InetAddress getAddress() {
            return this.address;
        }

        public static RemoteExecCapabilityFromDefinition of(ManagementContext mgmt, ConnectionDefinition definition) {
            return new RemoteExecCapabilityFromDefinition(mgmt, definition);
        }

        public static RemoteExecCapabilityFromDefinition of(Entity entity, ConnectionDefinition definition) {
            return new RemoteExecCapabilityFromDefinition(((EntityInternal)entity).getManagementContext(), definition);
        }

        protected RemoteExecCapabilityFromDefinition(ManagementContext mgmt, ConnectionDefinition definition) {
            this.mgmt = mgmt;
            this.definition = definition;
            if ("ssh".equals(definition.getType())) {
                this.config = this.resolveConnectionSettings();
                this.address = this.config.get("host").equals("localhost") ? BrooklynNetworkUtils.getLocalhostInetAddress() : Networking.resolve((String)this.config.get("host").toString());
            }
        }

        @Override
        public String getConnectionSummary() {
            return this.definition.getUser().get() + "@" + this.definition.getHost();
        }

        private Map<String, Object> resolveConnectionSettings() {
            AtomicReference<String> s = new AtomicReference<String>();
            try {
                MutableMap config = MutableMap.of();
                this.definition.getOther().forEach((k, v) -> {
                    s.set((String)k);
                    config.put(k, v instanceof WrappedValue ? v.get() : v);
                });
                s.set("user");
                config.put(s.get(), WrappedValue.getMaybe(this.definition.getUser()).or(() -> System.getProperty("user.name")));
                s.set("password");
                config.put(s.get(), WrappedValue.get(this.definition.getPassword()));
                s.set("host");
                config.put(s.get(), (Object)WrappedValue.get(this.definition.getHost()));
                s.set("port");
                config.put(s.get(), WrappedValue.getMaybe(this.definition.getPort()).or((Object)"22"));
                return config;
            }
            catch (Throwable e) {
                Exceptions.propagateIfFatal((Throwable)e);
                throw new IllegalArgumentException("Connection settings could not be resolved (resolving '" + s + "')", e);
            }
        }

        @Override
        public Integer execScript(Map<String, Object> allConfig, String summary, List<String> commands, Map<String, String> shellEnvironment) {
            return this.newExecWithLoggingHelpers().execScript(allConfig, summary, commands, shellEnvironment);
        }

        @Override
        public Integer execCommands(Map<String, Object> allConfig, String summary, List<String> commands, Map<String, String> shellEnvironment) {
            return this.newExecWithLoggingHelpers().execCommands(allConfig, summary, commands, shellEnvironment);
        }

        @Override
        public Configurable.ConfigurationSupport getExtraConfiguration() {
            return new BasicConfigurableObject().config();
        }

        @Override
        public ManagementContext getManagementContext() {
            return this.mgmt;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected <T> T execSsh(Map<String, ?> props, Function<ShellTool, T> task) {
            String sshToolClass = SshjTool.class.getName();
            try {
                SshTool ssh = (SshTool)new ClassLoaderUtils((Object)this, this.getManagementContext()).loadClass(sshToolClass).getConstructor(Map.class).newInstance(this.config);
                if (LOG.isTraceEnabled()) {
                    LOG.trace("using ssh-tool {} (of type {}); props ", (Object)ssh, (Object)sshToolClass);
                }
                try {
                    Tasks.setBlockingDetails("Opening ssh connection");
                    ssh.connect();
                    Object object = task.apply((Object)ssh);
                    return (T)object;
                }
                finally {
                    block11: {
                        try {
                            ssh.disconnect();
                        }
                        catch (Exception e) {
                            if (!logSsh.isDebugEnabled()) break block11;
                            logSsh.debug("ssh-disconnect failed from {}", (Object)this.getConnectionSummary(), (Object)e);
                        }
                    }
                    Tasks.setBlockingDetails(null);
                }
            }
            catch (Exception e) {
                String string;
                String rootCause = Throwables.getRootCause((Throwable)e).getMessage();
                StringBuilder stringBuilder = new StringBuilder().append("Cannot establish ssh connection to ").append(this.getConnectionSummary());
                if (rootCause != null && !rootCause.isEmpty()) {
                    string = " (" + rootCause + ")";
                    throw new IllegalStateException(stringBuilder.append(string).append(". \nEnsure that passwordless and passphraseless ssh access is enabled using standard keys from ~/.ssh or as configured in brooklyn.properties. Check that the target host is accessible, that credentials are correct (location and permissions if using a key), that the SFTP subsystem is available on the remote side, and that there is sufficient random noise in /dev/random on both ends. To debug less common causes, see the original error in the trace or log, and/or enable 'net.schmizz' (sshj) logging.").toString(), e);
                }
                string = "";
                throw new IllegalStateException(stringBuilder.append(string).append(". \nEnsure that passwordless and passphraseless ssh access is enabled using standard keys from ~/.ssh or as configured in brooklyn.properties. Check that the target host is accessible, that credentials are correct (location and permissions if using a key), that the SFTP subsystem is available on the remote side, and that there is sufficient random noise in /dev/random on both ends. To debug less common causes, see the original error in the trace or log, and/or enable 'net.schmizz' (sshj) logging.").toString(), e);
            }
        }

        protected ExecWithLoggingHelpers newExecWithLoggingHelpers() {
            return new ExecWithLoggingHelpers("SSH"){

                @Override
                protected <T> T execWithTool(MutableMap<String, Object> props, Function<ShellTool, T> function) {
                    return this.execSsh((Map<String, ?>)props, function);
                }

                @Override
                protected void preExecChecks() {
                    Preconditions.checkNotNull((Object)address, (Object)"host address must be specified for ssh");
                }

                @Override
                protected String getTargetName() {
                    return "" + this;
                }

                @Override
                protected String constructDefaultLoggingPrefix(ConfigBag execFlags) {
                    String hostname = address.getHostName();
                    return (config.get("user") != null ? config.get("user") + "@" : "") + hostname + (config.get("port") != null ? ":" + config.get("port") : "");
                }
            }.logger(logSsh);
        }
    }

    public static class RemoteExecCapabilityFromLocation
    implements RemoteExecCapability {
        MachineLocation machine;

        public RemoteExecCapabilityFromLocation(MachineLocation machine) {
            this.machine = machine;
        }

        @Override
        public String getConnectionSummary() {
            return this.machine.getUser() + "@" + this.machine.getAddress().getHostName();
        }

        @Override
        public Integer execScript(Map<String, Object> allConfig, String summary, List<String> commands, Map<String, String> shellEnvironment) {
            return this.machine.execScript(allConfig, summary, commands, shellEnvironment);
        }

        @Override
        public Integer execCommands(Map<String, Object> allConfig, String summary, List<String> commands, Map<String, String> shellEnvironment) {
            return this.machine.execCommands(allConfig, summary, commands, shellEnvironment);
        }

        @Override
        public Configurable.ConfigurationSupport getExtraConfiguration() {
            return this.machine.config();
        }

        @Override
        public ManagementContext getManagementContext() {
            return this.machine instanceof AbstractLocation ? ((AbstractLocation)this.machine).getManagementContext() : null;
        }
    }

    public static interface RemoteExecCapability {
        public String getConnectionSummary();

        public Integer execScript(Map<String, Object> var1, String var2, List<String> var3, Map<String, String> var4);

        public Integer execCommands(Map<String, Object> var1, String var2, List<String> var3, Map<String, String> var4);

        public Configurable.ConfigurationSupport getExtraConfiguration();

        public ManagementContext getManagementContext();
    }
}

