/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.workflow.steps.flow;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.objs.BrooklynObject;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.mgmt.BrooklynTaskTags;
import org.apache.brooklyn.core.resolve.jackson.JsonPassThroughDeserializer;
import org.apache.brooklyn.core.workflow.WorkflowExecutionContext;
import org.apache.brooklyn.core.workflow.WorkflowReplayUtils;
import org.apache.brooklyn.core.workflow.WorkflowStepDefinition;
import org.apache.brooklyn.core.workflow.WorkflowStepInstanceExecutionContext;
import org.apache.brooklyn.core.workflow.WorkflowStepResolution;
import org.apache.brooklyn.util.core.predicates.DslPredicates;
import org.apache.brooklyn.util.core.task.DynamicTasks;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwitchWorkflowStep
extends WorkflowStepDefinition
implements WorkflowStepDefinition.WorkflowStepDefinitionWithSubWorkflow {
    private static final Logger log = LoggerFactory.getLogger(SwitchWorkflowStep.class);
    public static final String SHORTHAND = "[ ${value} ]";
    public static final ConfigKey<List> CASES = ConfigKeys.newConfigKey(List.class, "cases");
    public static final ConfigKey<Object> VALUE = ConfigKeys.newConfigKey(Object.class, "value");
    @JsonDeserialize(contentUsing=JsonPassThroughDeserializer.class)
    List<Object> cases;

    @Override
    public void populateFromShorthand(String expression) {
        this.populateFromShorthandTemplate(SHORTHAND, expression);
    }

    @Override
    public void validateStep(@Nullable ManagementContext mgmt, @Nullable WorkflowExecutionContext workflow) {
        super.validateStep(mgmt, workflow);
        if (this.cases == null) {
            throw new IllegalStateException("No cases defined for " + (String)Strings.firstNonBlank((CharSequence[])new String[]{this.getName(), "switch"}));
        }
        List<WorkflowStepDefinition> stepsResolved = WorkflowStepResolution.resolveSubSteps(mgmt, (String)Strings.firstNonBlank((CharSequence[])new String[]{this.getName(), "switch"}), this.cases);
        if (stepsResolved.size() > 1) {
            for (int i = 0; i < stepsResolved.size() - 1; ++i) {
                if (stepsResolved.get(i).getConditionRaw() != null) continue;
                throw new IllegalStateException("All but the last case to a switch block must specify a condition; case " + (i + 1) + " does not");
            }
        }
    }

    @Override
    protected StepState getStepState(WorkflowStepInstanceExecutionContext context) {
        return (StepState)super.getStepState(context);
    }

    void setStepState(WorkflowStepInstanceExecutionContext context, boolean persist, WorkflowStepDefinition selectedStepDefinition, WorkflowStepInstanceExecutionContext selectedStepContext) {
        StepState state = new StepState();
        state.selectedStepDefinition = selectedStepDefinition;
        state.selectedStepContext = selectedStepContext;
        context.setStepState(state, persist);
    }

    protected <T> Maybe<T> runOnStepStateIfHasSubWorkflows(WorkflowStepInstanceExecutionContext context, Function<WorkflowStepDefinition.WorkflowStepDefinitionWithSubWorkflow, T> fn) {
        StepState state = this.getStepState(context);
        if (state != null && state.selectedStepDefinition instanceof WorkflowStepDefinition.WorkflowStepDefinitionWithSubWorkflow) {
            return Maybe.of(fn.apply((WorkflowStepDefinition.WorkflowStepDefinitionWithSubWorkflow)((Object)state.selectedStepDefinition)));
        }
        return Maybe.absent((String)(state == null ? "no state" : "not a subworkflow-enabled substep"));
    }

    @Override
    protected Object doTaskBody(WorkflowStepInstanceExecutionContext context) {
        List<WorkflowStepDefinition> stepsResolved = WorkflowStepResolution.resolveSubSteps(context.getManagementContext(), this.getName(), this.cases);
        Object valueResolved = context.getInput(VALUE);
        for (int i = 0; i < stepsResolved.size(); ++i) {
            WorkflowStepDefinition subStep = stepsResolved.get(i);
            WorkflowStepInstanceExecutionContext subStepContext = new WorkflowStepInstanceExecutionContext(context.getStepIndex(), subStep, context.getWorkflowExectionContext());
            String potentialTaskName = Tasks.current().getDisplayName() + "-" + (i + 1);
            DslPredicates.DslPredicate condition = subStep.getConditionResolved(subStepContext);
            if (condition != null) {
                if (log.isTraceEnabled()) {
                    log.trace("Considering condition " + condition + " for " + potentialTaskName);
                }
                boolean conditionMet = DslPredicates.evaluateDslPredicateWithBrooklynObjectContext(condition, valueResolved, (BrooklynObject)subStepContext.getEntity());
                if (log.isTraceEnabled()) {
                    log.trace("Considered condition " + condition + " for " + potentialTaskName + ": " + conditionMet);
                }
                if (!conditionMet) continue;
            }
            this.setStepState(context, true, subStep, subStepContext);
            Task<?> handlerI = subStep.newTaskAsSubTask(subStepContext, potentialTaskName, BrooklynTaskTags.tagForWorkflowSubStep(context, i));
            log.debug("Switch matched at substep " + i + ", running " + potentialTaskName + " '" + subStep.computeName(subStepContext, false) + "' in task " + handlerI.getId());
            Object result = DynamicTasks.queue(handlerI).getUnchecked();
            context.next = WorkflowReplayUtils.getNext(subStepContext, subStep, context, this);
            context.noteOtherMetadata("Switch match", "Case " + (i + 1) + ": " + (String)Strings.firstNonBlank((CharSequence[])new String[]{subStepContext.getName(), subStepContext.getWorkflowStepReference()}));
            context.otherMetadata.putAll(subStepContext.otherMetadata);
            return result;
        }
        throw new IllegalStateException("No cases match switch statement; include a final `no-op` case if this is intentional");
    }

    @Override
    public WorkflowStepDefinition.SubWorkflowsForReplay getSubWorkflowsForReplay(WorkflowStepInstanceExecutionContext context, boolean forced, boolean peekingOnly, boolean allowInternallyEvenIfDisabled) {
        return (WorkflowStepDefinition.SubWorkflowsForReplay)this.runOnStepStateIfHasSubWorkflows(context, s -> s.getSubWorkflowsForReplay(context, forced, peekingOnly, allowInternallyEvenIfDisabled)).get();
    }

    @Override
    public Object doTaskBodyWithSubWorkflowsForReplay(WorkflowStepInstanceExecutionContext context, @Nonnull List<WorkflowExecutionContext> subworkflows, WorkflowStepDefinition.ReplayContinuationInstructions instructions) {
        return this.runOnStepStateIfHasSubWorkflows(context, s -> s.doTaskBodyWithSubWorkflowsForReplay(context, subworkflows, instructions)).get();
    }

    @Override
    protected Boolean isDefaultIdempotent() {
        return null;
    }

    static class StepState {
        WorkflowStepDefinition selectedStepDefinition;
        WorkflowStepInstanceExecutionContext selectedStepContext;

        StepState() {
        }
    }
}

