/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.domain.vpn;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.jclouds.azurecompute.arm.domain.IdReference;
import org.jclouds.azurecompute.arm.domain.IpAllocationMethod;
import org.jclouds.azurecompute.arm.domain.Provisionable;
import org.jclouds.azurecompute.arm.domain.vpn.AutoValue_VirtualNetworkGatewayProperties;
import org.jclouds.azurecompute.arm.domain.vpn.AutoValue_VirtualNetworkGatewayProperties_IpConfiguration;
import org.jclouds.azurecompute.arm.domain.vpn.AutoValue_VirtualNetworkGatewayProperties_IpConfiguration_IpConfigurationProperties;
import org.jclouds.azurecompute.arm.domain.vpn.BGPSettings;
import org.jclouds.azurecompute.arm.domain.vpn.SKU;
import org.jclouds.azurecompute.arm.domain.vpn.VPNClientConfiguration;
import org.jclouds.azurecompute.arm.domain.vpn.VPNType;
import org.jclouds.azurecompute.arm.domain.vpn.VirtualNetworkGatewayType;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;

public abstract class VirtualNetworkGatewayProperties
implements Provisionable {
    @Nullable
    public abstract Boolean activeActive();

    @Nullable
    public abstract BGPSettings bgpSettings();

    public abstract boolean enableBGP();

    @Nullable
    public abstract IdReference gatewayDefaultSite();

    public abstract VirtualNetworkGatewayType gatewayType();

    public abstract List<IpConfiguration> ipConfigurations();

    @Override
    @Nullable
    public abstract String provisioningState();

    @Nullable
    public abstract String resourceGuid();

    public abstract SKU sku();

    @Nullable
    public abstract VPNClientConfiguration vpnClientConfiguration();

    @Nullable
    public abstract VPNType vpnType();

    VirtualNetworkGatewayProperties() {
    }

    @SerializedNames(value={"activeActive", "bgpSettings", "enableBgp", "gatewayDefaultSite", "gatewayType", "ipConfigurations", "provisioningState", "resourceGuid", "sku", "vpnClientConfiguration", "vpnType"})
    public static VirtualNetworkGatewayProperties create(Boolean activeActive, BGPSettings bgpSettings, boolean enableBGP, IdReference gatewayDefaultSite, VirtualNetworkGatewayType gatewayType, List<IpConfiguration> ipConfigurations, String provisioningState, String resourceGuid, SKU sku, VPNClientConfiguration vpnClientConfiguration, VPNType vpnType) {
        return VirtualNetworkGatewayProperties.builder(enableBGP, gatewayType, sku).activeActive(activeActive).bgpSettings(bgpSettings).gatewayDefaultSite(gatewayDefaultSite).ipConfigurations(ipConfigurations).provisioningState(provisioningState).resourceGuid(resourceGuid).vpnClientConfiguration(vpnClientConfiguration).vpnType(vpnType).build();
    }

    public static Builder builder(boolean enableBGP, VirtualNetworkGatewayType virtualNetworkGatewayType, SKU sku) {
        return new AutoValue_VirtualNetworkGatewayProperties.Builder().enableBGP(enableBGP).gatewayType(virtualNetworkGatewayType).sku(sku).ipConfigurations((List<IpConfiguration>)ImmutableList.of());
    }

    public abstract Builder toBuilder();

    public static abstract class IpConfiguration {
        @Nullable
        public abstract String id();

        public abstract String name();

        @Nullable
        public abstract String etag();

        public abstract IpConfigurationProperties properties();

        IpConfiguration() {
        }

        @SerializedNames(value={"id", "name", "etag", "properties"})
        public static IpConfiguration create(String id, String name, String etag, IpConfigurationProperties properties) {
            return new AutoValue_VirtualNetworkGatewayProperties_IpConfiguration(id, name, etag, properties);
        }

        public static abstract class IpConfigurationProperties
        implements Provisionable {
            public abstract IpAllocationMethod privateIPAllocationMethod();

            @Override
            @Nullable
            public abstract String provisioningState();

            @Nullable
            public abstract IdReference publicIPAddress();

            @Nullable
            public abstract IdReference subnet();

            @SerializedNames(value={"privateIPAllocationMethod", "provisioningState", "publicIPAddress", "subnet"})
            public static IpConfigurationProperties create(IpAllocationMethod privateIPAllocationMethod, String provisioningState, IdReference publicIPAddress, IdReference subnet) {
                return IpConfigurationProperties.builder(privateIPAllocationMethod).provisioningState(provisioningState).publicIPAddress(publicIPAddress).subnet(subnet).build();
            }

            IpConfigurationProperties() {
            }

            public static Builder builder(IpAllocationMethod privateIPAllocationMethod) {
                return new AutoValue_VirtualNetworkGatewayProperties_IpConfiguration_IpConfigurationProperties.Builder().privateIPAllocationMethod(privateIPAllocationMethod);
            }

            public abstract Builder toBuilder();

            public static abstract class Builder {
                public abstract Builder privateIPAllocationMethod(IpAllocationMethod var1);

                public abstract Builder provisioningState(String var1);

                public abstract Builder publicIPAddress(IdReference var1);

                public abstract Builder subnet(IdReference var1);

                public abstract IpConfigurationProperties build();
            }
        }
    }

    public static abstract class Builder {
        public abstract Builder activeActive(Boolean var1);

        public abstract Builder bgpSettings(BGPSettings var1);

        public abstract Builder enableBGP(boolean var1);

        public abstract Builder gatewayDefaultSite(IdReference var1);

        public abstract Builder gatewayType(VirtualNetworkGatewayType var1);

        public abstract Builder ipConfigurations(List<IpConfiguration> var1);

        public abstract Builder provisioningState(String var1);

        public abstract Builder resourceGuid(String var1);

        public abstract Builder sku(SKU var1);

        public abstract Builder vpnClientConfiguration(VPNClientConfiguration var1);

        public abstract Builder vpnType(VPNType var1);

        abstract List<IpConfiguration> ipConfigurations();

        abstract VirtualNetworkGatewayProperties autoBuild();

        public VirtualNetworkGatewayProperties build() {
            this.ipConfigurations((List<IpConfiguration>)(this.ipConfigurations() == null ? ImmutableList.of() : ImmutableList.copyOf(this.ipConfigurations())));
            return this.autoBuild();
        }
    }
}

